unit Adj_ypos;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, sctctrl, Sctvar, Sctrep, DB, DBTables, StdCtrls, Buttons,
  Sctbtn, ExtCtrls;

type
  TForm1 = class(TForm)
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    SctReportButton1: TSctReportButton;
    DataSource1: TDataSource;
    Table1: TTable;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    DataSourceGuide: TSctDataSourceGuide;
    table1LAST_NAME: TSctdbvar;
    table1FIRST_NAME: TSctdbvar;
    table1ACCT_NBR: TSctdbvar;
    table1ADDRESS_1: TSctdbvar;
    table1CITY: TSctdbvar;
    table1STATE: TSctdbvar;
    table1ZIP: TSctdbvar;
    table1TELEPHONE: TSctdbvar;
    table1DATE_OPEN: TSctdbvar;
    table1SS_NUMBER: TSctdbvar;
    table1PICTURE: TSctdbvar;
    table1BIRTH_DATE: TSctdbvar;
    table1RISK_LEVEL: TSctdbvar;
    table1OCCUPATION: TSctdbvar;
    table1OBJECTIVES: TSctdbvar;
    table1INTERESTS: TSctdbvar;
    table1IMAGE: TSctdbvar;
    TSctvarlabel: TSctvarlabel;
    TSctTextLabel: TSctTextLabel;
    TSctvarlabel1: TSctvarlabel;
    TSctTextLabel1: TSctTextLabel;
    ItemsBand: TSctSubDataBand;
    ItemsBandlevel: TSctLevel;
    Expr: TSctExprvar;
    Sctvarlabel1: TSctvarlabel;

    procedure DetailBandBeforePrint(band: TSctBand);
    procedure DetailBandAfterPrint(band: TSctBand);
    procedure ItemsBandDataStart(Sender: TObject);
    procedure ItemsBandDataSkip(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Tag: Integer;

implementation

{$R *.DFM}



procedure TForm1.DetailBandBeforePrint(band: TSctBand);
begin

  ReportPage.yPos := TRUNC(ReportPage.PixelsPerInch * (1+ (3.5 * tag)) );

end;

procedure TForm1.DetailBandAfterPrint(band: TSctBand);
begin

  tag := tag + 1;
  if tag > 2 then
    begin
      tag := 0;
      { We need to force this to the next page with a large number}
      band.ReserveSpace.Space := ReportPage.PixelsPerInch * 15;
    end
  else
    {This assumes that it is normally 0.  Since we are setting the}
    {position of the band each time, that's a safe bet here}
    band.ReserveSpace.Space := 0;
end;

procedure TForm1.ItemsBandDataStart(Sender: TObject);
begin
    Expr.AsInteger := 1;
end;

procedure TForm1.ItemsBandDataSkip(Sender: TObject);
begin
   Expr.AsInteger := Expr.AsInteger + 1;
   if Expr.AsInteger > tag+1 then
     TSctSubDataBand(Sender).DataIsFinished := True;
end;

end.
