unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, SctVar, SctCtrl, ExtCtrls, SctRep, ACEFILE;

type
  TForm1 = class(TForm)
    rpHalf: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    rp2Up: TSctReport;
    ReportPage1: TSctGrouppage;
    ReportHeaderBand1: TSctBand;
    ReportHeaderBand1level: TSctLevel;
    PageHeaderBand1: TSctBand;
    PageHeaderBand1level: TSctLevel;
    DetailBand1: TSctBand;
    DetailBand1level: TSctLevel;
    PageFooterBand1: TSctBand;
    PageFooterBand1level: TSctLevel;
    ReportFooterBand1: TSctBand;
    ReportFooterBand1level: TSctLevel;
    Sctvarlabel1: TSctvarlabel;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    varlabel: TSctvarlabel;
    varlabel1: TSctvarlabel;
    ExprVar: TSctExprVar;
    varlabel2: TSctvarlabel;
    Button1: TButton;
    lbImage: TSctImageLabel;
    svarDateTime1: TSctDateTimeVar;
    svarPage1: TSctPageVar;
    Image1: TImage;
    Memo1: TMemo;
    procedure ExprVarGetData(oVar: TSctVar);
    procedure ReportPageDataStart(Sender: TObject);
    procedure ReportPageDataSkip(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ReportPage1DataStart(Sender: TObject);
    procedure ReportPage1DataSkip(Sender: TObject);
    procedure ReportPage1AfterDataSkip(Page: TSctGrouppage);
  private
    { Private declarations }
    MyCounter: integer;
    aFile: TAceAceFile;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses psetup;


procedure TForm1.ExprVarGetData(oVar: TSctVar);
begin
  oVar.AsInteger := MyCounter;
end;

procedure TForm1.ReportPageDataStart(Sender: TObject);
begin
  MyCounter := 1;
  (Sender as TSctPage).DataIsFinished := (MyCounter > 100);
end;

procedure TForm1.ReportPageDataSkip(Sender: TObject);
begin
  Inc(MyCounter);
  (Sender as TSctPage).DataIsFinished := (MyCounter > 100);
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  cFile: string;
begin
  cFile := 'c:\2upTemp.ACE';
  rpHalf.Page.PageSetup.Destination := destFile;
  rpHalf.Page.AceFilename := cFile;
  rpHalf.Run;
  rp2Up.Page.PageSetup.AdjustMargin := False;
  rp2Up.Page.PageSetup.TopMargin := 0;
  rp2Up.Page.PageSetup.BottomMargin := 0;
  rp2Up.Page.PageSetup.LeftMargin := 0;
  rp2Up.Page.Detail.Height := 527; {5.5 in less 1 pixel}
  lbImage.Top := 24; {.5 in}
  lbImage.Height := 527; {4.5 in}
  lbImage.Left := 0;
  lbImage.Width := 720; {7.5 in}
  aFile := TAceAceFile.Create;
  aFile.LoadFromFile(cFile);
  rp2Up.Run;
  aFile.Free;
end;

procedure TForm1.ReportPage1DataStart(Sender: TObject);
begin
  MyCounter := 1;
  (Sender as TSctPage).DataIsFinished := (MyCounter > aFile.Pages.Count);
end;

procedure TForm1.ReportPage1DataSkip(Sender: TObject);
begin
  Inc(MyCounter);
  (Sender as TSctPage).DataIsFinished := (MyCounter > aFile.Pages.Count);
end;

procedure TForm1.ReportPage1AfterDataSkip(Page: TSctGrouppage);
var
    x    : Integer;
    aWmf : TMetafile;
    aWmfCanvas: TMetaFileCanvas;
begin
    aFile.HorzScale := 100;
    aFile.VertScale := 100;
    aWmf  := TMetaFile.Create;
    aWmf.Enhanced := True;
    aWmf.Height := 527;
    aWmf.Width  := 720;
    aWmfCanvas := TMetaFileCanvas.Create(aWmf,0) ;
    aFile.PlayPage(aWmfCanvas.Handle,MyCounter);
    aWmfCanvas.Free;
    try
      lbImage.Picture.Assign(aWmf);
    finally
      aWmf.Free;
    end;
end;

end.
