unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, SctBtn, SctCtrl, SctVar, ExtCtrls, SctRep,
  StBarC, AcePage, DB, DBTables, St2DBarC, StBarPN;

type
  TForm1 = class(TForm)
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    SctReportButton1: TSctReportButton;
    BarCode1: TStBarCode;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    ExprVar1: TSctExprVar;
    SctImageLabel1: TSctImageLabel;
    Table1: TTable;
    DataSource1: TDataSource;
    DataSourceGuide: TSctDataSourceGuide;
    table1EmpNoVar: TSctDBVar;
    table1LastNameVar: TSctDBVar;
    table1FirstNameVar: TSctDBVar;
    table1PhoneExtVar: TSctDBVar;
    table1HireDateVar: TSctDBVar;
    table1SalaryVar: TSctDBVar;
    BarCode3: TStPDF417Barcode;
    Sctvarlabel1: TSctvarlabel;
    Sctvarlabel2: TSctvarlabel;
    BarCode2: TStPNBarCode;
    BarCode4: TStMaxiCodeBarcode;
    SctImageLabel2: TSctImageLabel;
    SctImageLabel3: TSctImageLabel;
    SctImageLabel4: TSctImageLabel;
    ExprVar2: TSctExprVar;
    ExprVar3: TSctExprVar;
    ExprVar4: TSctExprVar;
    procedure ExprVar1GetData(oVar: TSctVar);
    procedure ExprVar2GetData(oVar: TSctVar);
    procedure ExprVar3GetData(oVar: TSctVar);
    procedure ExprVar4GetData(oVar: TSctVar);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.ExprVar1GetData(oVar: TSctVar);
var
  Stream: TStream;
  MetaFile: TMetaFile;
  MetaFileCanvas: TMetaFileCanvas;
begin
  MetaFile := TMetaFile.Create;
  BarCode1.Code := Table1EmpNoVar.AsString;
  MetaFile.Width := BarCode1.Width;
  MetaFile.Height := BarCode1.Height;
  MetaFileCanvas := TMetaFileCanvas.Create(MetaFile, 0);
  BarCode1.PaintToCanvas(MetaFileCanvas, Bounds(0,0,BarCode1.Width, BarCode1.Height));
  MetaFileCanvas.Free;
  Stream := TMemoryStream.Create;
  MetaFile.SaveToStream(Stream);
  oVar.AsStream := Stream;
  Stream.Free;
  MetaFile.Free;
end;

procedure TForm1.ExprVar2GetData(oVar: TSctVar);
var
  Stream: TStream;
  MetaFile: TMetaFile;
  MetaFileCanvas: TMetaFileCanvas;
begin
  MetaFile := TMetaFile.Create;
  BarCode2.PostalCode := IntToStr(12345 + Table1EmpNoVar.AsInteger);
  MetaFile.Width := BarCode2.Width;
  MetaFile.Height := BarCode2.Height;
  MetaFileCanvas := TMetaFileCanvas.Create(MetaFile, 0);
  BarCode2.PaintToCanvas(MetaFileCanvas, Point(0,0));
  MetaFileCanvas.Free;
  Stream := TMemoryStream.Create;
  MetaFile.SaveToStream(Stream);
  oVar.AsStream := Stream;
  Stream.Free;
  MetaFile.Free;
end;

procedure TForm1.ExprVar3GetData(oVar: TSctVar);
var
  Stream: TStream;
  MetaFile: TMetaFile;
  MetaFileCanvas: TMetaFileCanvas;
begin
  MetaFile := TMetaFile.Create;
  BarCode3.Caption := Table1EmpNoVar.AsString;
  MetaFile.Width := BarCode3.Width;
  MetaFile.Height := BarCode3.Height;
  MetaFileCanvas := TMetaFileCanvas.Create(MetaFile, 0);
  BarCode3.PaintToCanvas(MetaFileCanvas, Point(0,0));
  MetaFileCanvas.Free;
  Stream := TMemoryStream.Create;
  MetaFile.SaveToStream(Stream);
  oVar.AsStream := Stream;
  Stream.Free;
  MetaFile.Free;
end;

procedure TForm1.ExprVar4GetData(oVar: TSctVar);
var
  Stream: TStream;
  MetaFile: TMetaFile;
  MetaFileCanvas: TMetaFileCanvas;
begin
  MetaFile := TMetaFile.Create;
  BarCode4.Caption := Table1EmpNoVar.AsString;
  MetaFile.Width := BarCode4.Width;
  MetaFile.Height := BarCode4.Height;
  MetaFileCanvas := TMetaFileCanvas.Create(MetaFile, 0);
  BarCode4.PaintToCanvas(MetaFileCanvas, Point(0,0));
  MetaFileCanvas.Free;
  Stream := TMemoryStream.Create;
  MetaFile.SaveToStream(Stream);
  oVar.AsStream := Stream;
  Stream.Free;
  MetaFile.Free;
end;

end.
