unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SctVar, AcePage, SctRep, Db, DBTables, SctCtrl, ExtCtrls, StdCtrls,
  Buttons, SctBtn;

type
  TForm1 = class(TForm)
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    OverlayBand: TSctOverlayBand;
    OverlayBandLevel: TSctLevel;
    Sctvarlabel1: TSctvarlabel;
    DataSource1: TDataSource;
    Table1: TTable;
    DataSourceGuide: TSctDataSourceGuide;
    SctReportButton1: TSctReportButton;
    table1OrderNoVar: TSctDBVar;
    table1CustNoVar: TSctDBVar;
    table1SaleDateVar: TSctDBVar;
    table1ShipDateVar: TSctDBVar;
    table1EmpNoVar: TSctDBVar;
    table1ShipToContactVar: TSctDBVar;
    table1ShipToAddr1Var: TSctDBVar;
    table1ShipToAddr2Var: TSctDBVar;
    table1ShipToCityVar: TSctDBVar;
    table1ShipToStateVar: TSctDBVar;
    table1ShipToZipVar: TSctDBVar;
    table1ShipToCountryVar: TSctDBVar;
    table1ShipToPhoneVar: TSctDBVar;
    table1ShipVIAVar: TSctDBVar;
    table1POVar: TSctDBVar;
    table1TermsVar: TSctDBVar;
    table1PaymentMethodVar: TSctDBVar;
    table1ItemsTotalVar: TSctDBVar;
    table1TaxRateVar: TSctDBVar;
    table1FreightVar: TSctDBVar;
    table1AmountPaidVar: TSctDBVar;
    varlabel: TSctvarlabel;
    varlabel1: TSctvarlabel;
    varlabel2: TSctvarlabel;
    varlabel3: TSctvarlabel;
    varlabel4: TSctvarlabel;
    varlabel5: TSctvarlabel;
    varlabel6: TSctvarlabel;
    varlabel7: TSctvarlabel;
    procedure PageHeaderBandAfterPrint(Band: TSctBand);
    procedure OverlayBandAfterPrint(Band: TSctBand);
    procedure SctReport1BeforePrint(Report: TSctReport);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.PageHeaderBandAfterPrint(Band: TSctBand);
var
  Page: TSctPage;
  Offset,BandSize: Integer;
  function GetBandHeight(band: TSctBand): Integer;
  var
    Spot: Integer;
  begin
    if Band.Labels <> nil then
    begin
      for Spot := 0 to Band.Labels.Count - 1 do TSctLabel(Band.Labels.Items[Spot]).StartPrint;
      Result := Band.SpendHeight(TSctPage(Band.Parent), 2000);
      for Spot := 0 to Band.Labels.Count - 1 do
        TSctLabel(Band.Labels.Items[Spot]).EndPrint := True;
    end else Result := Band.Height;
  end;
begin
  if OverlayBand.Visible then
  begin
    Page := TSctPage(Band.Parent);
    BandSize := GetBandHeight(OverLayBand);
    Offset := Trunc((Page.PageSetup.Height - Page.PageSetup.TopMargin - Page.PageSetup.BottomMargin)*Page.PixelsPerInch)
       - Page.PFHeight - BandSize;
    OverLayBand.TopOffset := Offset;
    DetailBand.ReserveSpace.Space := BandSize;
  end else DetailBand.ReserveSpace.Space := 0;
end;

procedure TForm1.OverlayBandAfterPrint(Band: TSctBand);
begin
  Band.Visible := False;
end;

procedure TForm1.SctReport1BeforePrint(Report: TSctReport);
begin
  OverLayBand.Visible := True;
end;

end.
