unit Unit1;
{Copyright 2001, SCT Associates, Inc. by Steven Tyrakowski}

{ Design Notes

This report illustrates a lot of techniques that can be very useful.
Look at the fairly small amount of code needed to create 3 levels of totals
and to sparsely populate columns of data for records that meet that column's
criteria.

Note the technique used to optionally select different data elements to print
by putting each element on its own subband.  A single event controls all the
suppressing by referenceing the Tag of the band to the data element's
position in the checkboxlist.

Additional suppressing is done at the subtotal level by using the visible
property.  This makes each band conveniently have 2 different ways to be
suppressed without needing to code in the and/or logic.

Note the technique for doing averages.  Normally, each record gets added into
the count for a total variable.  However, sine this is a sparsely populated
grid, we only want to count the ones that have data for that column.  This
is easily accomplished by using the TotalVariable's IgnoreNulls property
which you access by selecting the totalvar via the DataControl Center.

Since the totalvars already do averages, we can calculate a percentage
by adding 100 for each True value, and then doing an average.  Look at
the code for the nPct variable to see how this is done.

Also note that with sparsely populated amounts, when we look at the Count and
percent of orders that have a qty > 2, we need to distinguish between
a zero value and a null value.  This is done by combining the use of the
IgnoreNulls property on the totalvar and the LabelprintWhen event WhenAnyRecs
which is written generically only using the passed parameter.

Also note the techniques used to allow 2 different sort orders based
on the checkCust and checkPart checkboxes.  We create a second SELECT
statement that forces all customers to be the same so it won't trigger
the control break in the report, and we suppress thos bands from displaying.

There are a bunch of other little niceties such as only showing a line divider
between groups of data if more than one data element is selected.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SctVar, SctRep, AcePage, ExtCtrls, Grids, DBGrids, Db, DBTables, Menus,
  SctCtrl, StdCtrls, CheckLst, Buttons, SctBtn, ComCtrls;

type
  TForm1 = class(TForm)
    Query1: TQuery;
    DataSource1: TDataSource;
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    DataSourceGuide: TSctDataSourceGuide;
    query1custNoVar: TSctDBVar;
    query1saledateVar: TSctDBVar;
    query1partnoVar: TSctDBVar;
    query1qtyVar: TSctDBVar;
    query1descriptionVar: TSctDBVar;
    query1listpriceVar: TSctDBVar;
    query1costVar: TSctDBVar;
    Group: TSctGroup;
    GroupHeader: TSctBand;
    GroupHeaderLevel: TSctLevel;
    GroupFooter: TSctBand;
    GroupFooterLevel: TSctLevel;
    Group1: TSctGroup;
    Group1Header: TSctBand;
    Group1HeaderLevel: TSctLevel;
    Group1Footer: TSctBand;
    Group1FooterLevel: TSctLevel;
    Qty1Y: TSctExprVar;
    Qty2Y: TSctExprVar;
    Qty3Y: TSctExprVar;
    Qty4Y: TSctExprVar;
    Qty5Y: TSctExprVar;
    Qty6Y: TSctExprVar;
    Qty7Y: TSctExprVar;
    Qty8Y: TSctExprVar;
    List1Y: TSctExprVar;
    List2Y: TSctExprVar;
    List3Y: TSctExprVar;
    List4Y: TSctExprVar;
    List5Y: TSctExprVar;
    List6Y: TSctExprVar;
    List7Y: TSctExprVar;
    List8Y: TSctExprVar;
    Cost1Y: TSctExprVar;
    Cost2Y: TSctExprVar;
    Cost3Y: TSctExprVar;
    Cost4Y: TSctExprVar;
    Cost5Y: TSctExprVar;
    Cost6Y: TSctExprVar;
    Cost7Y: TSctExprVar;
    Cost8Y: TSctExprVar;
    Cnt1Y: TSctExprVar;
    Cnt2Y: TSctExprVar;
    Cnt3Y: TSctExprVar;
    Cnt4Y: TSctExprVar;
    Cnt5Y: TSctExprVar;
    Cnt6Y: TSctExprVar;
    Cnt7Y: TSctExprVar;
    Cnt8Y: TSctExprVar;
    Pct1Y: TSctExprVar;
    Pct2Y: TSctExprVar;
    Pct3Y: TSctExprVar;
    Pct4Y: TSctExprVar;
    Pct5Y: TSctExprVar;
    Pct6Y: TSctExprVar;
    Pct7Y: TSctExprVar;
    Pct8Y: TSctExprVar;
    TotalOfQty1Y: TSctTotalvar;
    TotalOfQty2Y: TSctTotalvar;
    TotalOfQty3Y: TSctTotalvar;
    TotalOfQty4Y: TSctTotalvar;
    TotalOfQty5Y: TSctTotalvar;
    TotalOfQty6Y: TSctTotalvar;
    TotalOfQty7Y: TSctTotalvar;
    TotalOfQty8Y: TSctTotalvar;
    TotalOfList1Y: TSctTotalvar;
    TotalOfList2Y: TSctTotalvar;
    TotalOfList3Y: TSctTotalvar;
    TotalOfList4Y: TSctTotalvar;
    TotalOfList5Y: TSctTotalvar;
    TotalOfList6Y: TSctTotalvar;
    TotalOfList7Y: TSctTotalvar;
    TotalOfList8Y: TSctTotalvar;
    TotalOfCost1Y: TSctTotalvar;
    TotalOfCost2Y: TSctTotalvar;
    TotalOfCost3Y: TSctTotalvar;
    TotalOfCost4Y: TSctTotalvar;
    TotalOfCost5Y: TSctTotalvar;
    TotalOfCost6Y: TSctTotalvar;
    TotalOfCost7Y: TSctTotalvar;
    TotalOfCost8Y: TSctTotalvar;
    TotalOfCnt1Y: TSctTotalvar;
    TotalOfCnt2Y: TSctTotalvar;
    TotalOfCnt3Y: TSctTotalvar;
    TotalOfCnt4Y: TSctTotalvar;
    TotalOfCnt5Y: TSctTotalvar;
    TotalOfCnt6Y: TSctTotalvar;
    TotalOfCnt7Y: TSctTotalvar;
    TotalOfCnt8Y: TSctTotalvar;
    TotalOfPct1Y: TSctTotalvar;
    TotalOfPct2Y: TSctTotalvar;
    TotalOfPct3Y: TSctTotalvar;
    TotalOfPct4Y: TSctTotalvar;
    TotalOfPct5Y: TSctTotalvar;
    TotalOfPct6Y: TSctTotalvar;
    TotalOfPct7Y: TSctTotalvar;
    TotalOfPct8Y: TSctTotalvar;
    Group1FooterSub: TSctSubBand;
    Group1FooterSub1: TSctSubBand;
    Group1FooterSub2: TSctSubBand;
    Group1FooterSub3: TSctSubBand;
    Group1FooterSub4: TSctSubBand;
    Group1FooterSub5: TSctSubBand;
    GroupFooterSub: TSctSubBand;
    GroupFooterSub1: TSctSubBand;
    GroupFooterSub2: TSctSubBand;
    GroupFooterSub3: TSctSubBand;
    GroupFooterSub4: TSctSubBand;
    GroupFooterSub5: TSctSubBand;
    ReportFooterBandSub: TSctSubBand;
    ReportFooterBandSub1: TSctSubBand;
    ReportFooterBandSub2: TSctSubBand;
    ReportFooterBandSub3: TSctSubBand;
    ReportFooterBandSub4: TSctSubBand;
    Sctvarlabel2: TSctvarlabel;
    Sctvarlabel3: TSctvarlabel;
    Sctvarlabel4: TSctvarlabel;
    Sctvarlabel5: TSctvarlabel;
    Sctvarlabel6: TSctvarlabel;
    CheckData: TCheckListBox;
    varlabel: TSctvarlabel;
    varlabel1: TSctvarlabel;
    TotalvarLabel: TSctTotalvarLabel;
    TotalvarLabel1: TSctTotalvarLabel;
    TotalvarLabel2: TSctTotalvarLabel;
    TotalvarLabel3: TSctTotalvarLabel;
    TotalvarLabel4: TSctTotalvarLabel;
    TotalvarLabel5: TSctTotalvarLabel;
    TotalvarLabel6: TSctTotalvarLabel;
    TotalvarLabel7: TSctTotalvarLabel;
    TotalvarLabel8: TSctTotalvarLabel;
    TotalvarLabel9: TSctTotalvarLabel;
    TotalvarLabel10: TSctTotalvarLabel;
    TotalvarLabel11: TSctTotalvarLabel;
    TotalvarLabel12: TSctTotalvarLabel;
    TotalvarLabel13: TSctTotalvarLabel;
    TotalvarLabel14: TSctTotalvarLabel;
    TotalvarLabel15: TSctTotalvarLabel;
    TotalvarLabel16: TSctTotalvarLabel;
    TotalvarLabel17: TSctTotalvarLabel;
    TotalvarLabel18: TSctTotalvarLabel;
    TotalvarLabel19: TSctTotalvarLabel;
    TotalvarLabel20: TSctTotalvarLabel;
    TotalvarLabel21: TSctTotalvarLabel;
    TotalvarLabel22: TSctTotalvarLabel;
    TotalvarLabel23: TSctTotalvarLabel;
    TotalvarLabel24: TSctTotalvarLabel;
    TotalvarLabel25: TSctTotalvarLabel;
    TotalvarLabel26: TSctTotalvarLabel;
    TotalvarLabel27: TSctTotalvarLabel;
    TotalvarLabel28: TSctTotalvarLabel;
    TotalvarLabel29: TSctTotalvarLabel;
    TotalvarLabel30: TSctTotalvarLabel;
    TotalvarLabel31: TSctTotalvarLabel;
    TotalvarLabel32: TSctTotalvarLabel;
    TotalvarLabel33: TSctTotalvarLabel;
    TotalvarLabel34: TSctTotalvarLabel;
    TotalvarLabel35: TSctTotalvarLabel;
    TotalvarLabel36: TSctTotalvarLabel;
    TotalvarLabel37: TSctTotalvarLabel;
    TotalvarLabel38: TSctTotalvarLabel;
    TotalvarLabel39: TSctTotalvarLabel;
    CheckCust: TCheckBox;
    CheckPart: TCheckBox;
    varlabel2: TSctvarlabel;
    Table1: TTable;
    Query1custNo: TFloatField;
    Query1saledate: TDateTimeField;
    Query1partno: TFloatField;
    Query1qty: TIntegerField;
    Query1description: TStringField;
    Query1listprice: TCurrencyField;
    Query1cost: TCurrencyField;
    Query1CustName: TStringField;
    query1CustNameVar: TSctDBVar;
    varlabel3: TSctvarlabel;
    Sctvarlabel1: TSctvarlabel;
    SctTotalvarLabel1: TSctTotalvarLabel;
    SctTotalvarLabel2: TSctTotalvarLabel;
    SctTotalvarLabel3: TSctTotalvarLabel;
    SctTotalvarLabel4: TSctTotalvarLabel;
    SctTotalvarLabel5: TSctTotalvarLabel;
    SctTotalvarLabel6: TSctTotalvarLabel;
    SctTotalvarLabel7: TSctTotalvarLabel;
    SctTotalvarLabel8: TSctTotalvarLabel;
    Sctvarlabel7: TSctvarlabel;
    SctTotalvarLabel9: TSctTotalvarLabel;
    SctTotalvarLabel10: TSctTotalvarLabel;
    SctTotalvarLabel11: TSctTotalvarLabel;
    SctTotalvarLabel12: TSctTotalvarLabel;
    SctTotalvarLabel13: TSctTotalvarLabel;
    SctTotalvarLabel14: TSctTotalvarLabel;
    SctTotalvarLabel15: TSctTotalvarLabel;
    SctTotalvarLabel16: TSctTotalvarLabel;
    Sctvarlabel8: TSctvarlabel;
    SctTotalvarLabel17: TSctTotalvarLabel;
    SctTotalvarLabel18: TSctTotalvarLabel;
    SctTotalvarLabel19: TSctTotalvarLabel;
    SctTotalvarLabel20: TSctTotalvarLabel;
    SctTotalvarLabel21: TSctTotalvarLabel;
    SctTotalvarLabel22: TSctTotalvarLabel;
    SctTotalvarLabel23: TSctTotalvarLabel;
    SctTotalvarLabel24: TSctTotalvarLabel;
    Sctvarlabel9: TSctvarlabel;
    SctTotalvarLabel25: TSctTotalvarLabel;
    SctTotalvarLabel26: TSctTotalvarLabel;
    SctTotalvarLabel27: TSctTotalvarLabel;
    SctTotalvarLabel28: TSctTotalvarLabel;
    SctTotalvarLabel29: TSctTotalvarLabel;
    SctTotalvarLabel30: TSctTotalvarLabel;
    SctTotalvarLabel31: TSctTotalvarLabel;
    SctTotalvarLabel32: TSctTotalvarLabel;
    Sctvarlabel10: TSctvarlabel;
    SctTotalvarLabel33: TSctTotalvarLabel;
    SctTotalvarLabel34: TSctTotalvarLabel;
    SctTotalvarLabel35: TSctTotalvarLabel;
    SctTotalvarLabel36: TSctTotalvarLabel;
    SctTotalvarLabel37: TSctTotalvarLabel;
    SctTotalvarLabel38: TSctTotalvarLabel;
    SctTotalvarLabel39: TSctTotalvarLabel;
    SctTotalvarLabel40: TSctTotalvarLabel;
    Sctvarlabel11: TSctvarlabel;
    Sctvarlabel12: TSctvarlabel;
    SctTotalvarLabel41: TSctTotalvarLabel;
    SctTotalvarLabel42: TSctTotalvarLabel;
    SctTotalvarLabel43: TSctTotalvarLabel;
    SctTotalvarLabel44: TSctTotalvarLabel;
    SctTotalvarLabel45: TSctTotalvarLabel;
    SctTotalvarLabel46: TSctTotalvarLabel;
    SctTotalvarLabel47: TSctTotalvarLabel;
    SctTotalvarLabel48: TSctTotalvarLabel;
    Sctvarlabel13: TSctvarlabel;
    SctTotalvarLabel49: TSctTotalvarLabel;
    SctTotalvarLabel50: TSctTotalvarLabel;
    SctTotalvarLabel51: TSctTotalvarLabel;
    SctTotalvarLabel52: TSctTotalvarLabel;
    SctTotalvarLabel53: TSctTotalvarLabel;
    SctTotalvarLabel54: TSctTotalvarLabel;
    SctTotalvarLabel55: TSctTotalvarLabel;
    SctTotalvarLabel56: TSctTotalvarLabel;
    Sctvarlabel14: TSctvarlabel;
    SctTotalvarLabel57: TSctTotalvarLabel;
    SctTotalvarLabel58: TSctTotalvarLabel;
    SctTotalvarLabel59: TSctTotalvarLabel;
    SctTotalvarLabel60: TSctTotalvarLabel;
    SctTotalvarLabel61: TSctTotalvarLabel;
    SctTotalvarLabel62: TSctTotalvarLabel;
    SctTotalvarLabel63: TSctTotalvarLabel;
    SctTotalvarLabel64: TSctTotalvarLabel;
    Sctvarlabel15: TSctvarlabel;
    SctTotalvarLabel65: TSctTotalvarLabel;
    SctTotalvarLabel66: TSctTotalvarLabel;
    SctTotalvarLabel67: TSctTotalvarLabel;
    SctTotalvarLabel68: TSctTotalvarLabel;
    SctTotalvarLabel69: TSctTotalvarLabel;
    SctTotalvarLabel70: TSctTotalvarLabel;
    SctTotalvarLabel71: TSctTotalvarLabel;
    SctTotalvarLabel72: TSctTotalvarLabel;
    Sctvarlabel16: TSctvarlabel;
    SctTotalvarLabel73: TSctTotalvarLabel;
    SctTotalvarLabel74: TSctTotalvarLabel;
    SctTotalvarLabel75: TSctTotalvarLabel;
    SctTotalvarLabel76: TSctTotalvarLabel;
    SctTotalvarLabel77: TSctTotalvarLabel;
    SctTotalvarLabel78: TSctTotalvarLabel;
    SctTotalvarLabel79: TSctTotalvarLabel;
    SctTotalvarLabel80: TSctTotalvarLabel;
    varlabel4: TSctvarlabel;
    varlabel5: TSctvarlabel;
    Sctvarlabel17: TSctvarlabel;
    PageHeaderBandSub: TSctSubBand;
    varlabel6: TSctvarlabel;
    varlabel7: TSctvarlabel;
    Y1lbl: TSctvarlabel;
    Y2Lbl: TSctvarlabel;
    Y4Lbl: TSctvarlabel;
    Y3Lbl: TSctvarlabel;
    Y8Lbl: TSctvarlabel;
    Y7Lbl: TSctvarlabel;
    Y5Lbl: TSctvarlabel;
    Y6Lbl: TSctvarlabel;
    RptDate: TDateTimePicker;
    Label1: TLabel;
    Sctvarlabel18: TSctvarlabel;
    Button1: TButton;
    Memo1: TMemo;
    procedure WhenDataChecked(Band: TSctBand;
      var Result: Boolean);
    procedure ReportPageAfterDataSkip(Page: TSctGrouppage);
    procedure FormShow(Sender: TObject);
    function SetupReport: boolean;
    procedure Sctvarlabel17LabelPrintWhen(lb: TSctLabel;
      var Result: Boolean);
    procedure WhenAnyRecs(lb: TSctLabel; var Result: Boolean);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    Yr, Mon, Day: word;
    nQty, nCnt, nPct: integer;
    nList, nCost: double;
    procedure SaveData(Flag: boolean; vQ, vL, vC, vCnt, vPct: TSctVar);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

uses SCTDATA;

procedure TForm1.WhenDataChecked(Band: TSctBand;
  var Result: Boolean);
begin
  Result := CheckData.Checked[Band.Tag];
end;

procedure TForm1.ReportPageAfterDataSkip(Page: TSctGrouppage);
var
  y,m,d: word;
begin
  nQty := Query1.FieldByName('qty').AsInteger;
  nList := nQty * Query1.FieldByName('listprice').AsFloat;
  nCost := nQty * Query1.FieldByName('cost').AsFloat;
  nCnt := 0;
  if nQty > 2 then nCnt := 1;
  nPct := 100 * nCnt;
  DecodeDate(query1.FieldByName('saledate').AsDateTime,y,m,d);
  SaveData((y+7 = Yr),Qty1Y,List1Y,Cost1Y,Cnt1Y,Pct1Y);
  SaveData((y+6 = Yr),Qty2Y,List2Y,Cost2Y,Cnt2Y,Pct2Y);
  SaveData((y+5 = Yr),Qty3Y,List3Y,Cost3Y,Cnt3Y,Pct3Y);
  SaveData((y+4 = Yr),Qty4Y,List4Y,Cost4Y,Cnt4Y,Pct4Y);
  SaveData((y+3 = Yr),Qty5Y,List5Y,Cost5Y,Cnt5Y,Pct5Y);
  SaveData((y+2 = Yr),Qty6Y,List6Y,Cost6Y,Cnt6Y,Pct6Y);
  SaveData((y+1 = Yr),Qty7Y,List7Y,Cost7Y,Cnt7Y,Pct7Y);
  SaveData((y   = Yr),Qty8Y,List8Y,Cost8Y,Cnt8Y,Pct8Y);
end;

procedure TForm1.SaveData(Flag: boolean; vQ, vL, vC, vCnt, vPct: TSctVar);
begin
  if Flag then
    begin
      vQ.AsInteger := nQty;
      vL.AsFloat := nList;
      vC.AsFloat := nCost;
      vCnt.IsNull := False;
      vCnt.AsInteger := nCnt;
      vPct.IsNull := False;
      vPct.AsInteger := nPct;
    end
  else
    begin
      vQ.AsInteger := 0;
      vL.AsFloat := 0;
      vC.AsFloat := 0;
      vCnt.IsNull := True;
      vCnt.AsInteger := 0;
      vPct.IsNull := True;
      vPct.AsInteger := 0;
    end;
end;


procedure TForm1.FormShow(Sender: TObject);
var
  i: integer;
begin
  TForm(Sender).Height := 300;
  TForm(Sender).Width := 450;
  for i:= 0 to CheckData.Items.Count-1 do CheckData.Checked[i] := True;
end;

function TForm1.SetupReport: boolean;
var
  i,CheckCount: integer;
begin
  CheckCount := 0;
  for i := 0 to CheckData.Items.Count-1 do
     if CheckData.Checked[i] then Inc(CheckCount);

  Result := CheckCount > 0;
  if CheckCount = 0 then
     ShowMessage('You must select at least one data element to print');

  if CheckCust.Checked then
    begin
      Query1.SQL.Text := ' select o.custNo, o.saledate, p.partno, i.qty,'
           + '        p.description, p.listprice, p.cost'
           + ' from orders o, items i, parts p'
           + ' where (o.orderno = i.orderno) and (i.partno = p.partno)'
           + ' Order By CustNo, partno';
    end
  else
    begin
      Query1.SQL.Text := ' select 0 as custNo, o.saledate, p.partno, i.qty,'
           + '        p.description, p.listprice, p.cost'
           + ' from orders o, items i, parts p'
           + ' where (o.orderno = i.orderno) and (i.partno = p.partno)'
           + ' Order By Partno';
    end;
  GroupFooter.Visible := CheckCust.Checked;
  GroupFooterSub.Visible := CheckCust.Checked;
  GroupFooterSub1.Visible := CheckCust.Checked;
  GroupFooterSub2.Visible := CheckCust.Checked;
  GroupFooterSub3.Visible := CheckCust.Checked;
  GroupFooterSub4.Visible := CheckCust.Checked;
  GroupFooterSub5.Visible := CheckCust.Checked and (CheckPart.Checked or (CheckCount > 1));
  Group1Footer.Visible := CheckPart.Checked;
  Group1FooterSub.Visible := CheckPart.Checked;
  Group1FooterSub1.Visible := CheckPart.Checked;
  Group1FooterSub2.Visible := CheckPart.Checked;
  Group1FooterSub3.Visible := CheckPart.Checked;
  Group1FooterSub4.Visible := CheckPart.Checked;
  Group1FooterSub5.Visible := CheckPart.Checked and (CheckCount > 1);
  GroupHeader.Visible := CheckPart.Checked and CheckCust.Checked;

  DecodeDate(RptDate.Date,Yr,Mon,Day);
  Y1Lbl.Caption := IntToStr(Yr-7);
  Y2Lbl.Caption := IntToStr(Yr-6);
  Y3Lbl.Caption := IntToStr(Yr-5);
  Y4Lbl.Caption := IntToStr(Yr-4);
  Y5Lbl.Caption := IntToStr(Yr-3);
  Y6Lbl.Caption := IntToStr(Yr-2);
  Y7Lbl.Caption := IntToStr(Yr-1);
  Y8Lbl.Caption := IntToStr(Yr);
end;

procedure TForm1.Sctvarlabel17LabelPrintWhen(lb: TSctLabel;
  var Result: Boolean);
begin
  Result := TSctBand(lb.Parent).Continued;
end;

procedure TForm1.WhenAnyRecs(lb: TSctLabel; var Result: Boolean);
begin
  Result := TSctTotalVarLabel(lb).TotalVariable.GetLevel(
           TSctBand(lb.Parent).UpdateLevel, ttCount).AsInteger > 0;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  ShowMessage(Memo1.Lines.text);
  if SetupReport then SctReport1.Run;
end;

end.
