unit RegPrnt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

function ChoosePrinter(Caption,CurrentChoice: String):String ;
function SetPrinter(PrinterName: String):Boolean;
function GetRegString( RegKey, RegString: String): String;
function SetRegString( RegKey, RegString, RegData: String): Boolean;
function SetRegistryPrinter(RegKey, RegString :String):Boolean;
function ChooseRegistryPrinter(RegKey, RegString :String):String;

implementation
uses printers, registry;

//-----------------------------------------------------------
function SetRegString( RegKey, RegString, RegData: String): Boolean;
var
  Reg: TRegistry;
begin
  Result := False;
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey(RegKey, True) then
      begin
        Reg.WriteString(RegString,RegData);
        Result := True;
      end;
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

//-----------------------------------------------------------
function GetRegString( RegKey, RegString: String): String;
var
  Reg: TRegistry;
begin
  Result := '';
  Reg := TRegistry.Create;
  try
    Reg.RootKey := HKEY_CURRENT_USER;
    if Reg.OpenKey(RegKey, True) then
        Result := Reg.ReadString(RegString);
  finally
    Reg.CloseKey;
    Reg.Free;
  end;
end;

//-----------------------------------------------------------
function SetRegistryPrinter(RegKey, RegString :String):Boolean;
var
  PrinterName: String;
begin
  PrinterName := GetRegString(RegKey, RegString);
  if Printer.Printers.IndexOf(PrinterName) < 0 then
     PrinterName := ChooseRegistryPrinter(RegKey, RegString);
  Result := SetPrinter(PrinterName);
end;

//-----------------------------------------------------------
function ChooseRegistryPrinter(RegKey, RegString :String):String;
var
  PrinterName: String;
begin
  PrinterName := GetRegString(RegKey, RegString);
  Result := ChoosePrinter('Select Printer ['+RegString+']',PrinterName);
  SetRegString(RegKey, RegString, Result);
end;

//-----------------------------------------------------------
function SetPrinter(PrinterName: String):Boolean;
var
  TargetPrinter: Integer;
  PSetup: TPrinterSetupDialog;
begin
  TargetPrinter := Printer.Printers.IndexOf(PrinterName);
  if TargetPrinter >= 0 then
    begin
      Result := True;
      Printer.PrinterIndex := TargetPrinter;
    end
  else
    begin
      ShowMessage('Printer: ['+PrinterName
            +'] is not installed, select another.');
      PSetup := TPrinterSetupDialog.Create(Application);
      Result := PSetup.Execute;
      PSetup.Free;
    end
end;

//-----------------------------------------------------------
function ChoosePrinter(Caption,CurrentChoice: String):String ;
var
  Frm: TForm;
  Combo: TComboBox;
  BtnOK, BtnCancel : TBitBtn;
begin
  Result := CurrentChoice;
  Frm := TForm.Create(Application);
  Frm.Caption := Caption;
  Frm.Width := 400;
  Frm.Height := 200;
  Frm.Position := poScreenCenter;
  Combo := TComboBox.Create(Frm);
  Combo.Parent := Frm;
  Combo.Width := 250;
  Combo.Top := 20;
  Combo.Left := 20;
  Combo.Style := csDropDownList;
  BtnOK := TBitBtn.Create(Frm);
  BtnOK.Parent := Frm;
  BtnOK.Left := 20;
  BtnOK.Top := 80;
  BtnOK.Kind := bkOK;

  BtnCancel := TBitBtn.Create(Frm);
  BtnCancel.Parent := Frm;
  BtnCancel.Left := 120;
  BtnCancel.Top := 80;
  BtnCancel.Kind := bkCancel;

  Combo.Items.AddStrings(Printer.Printers);
  Combo.ItemIndex := Combo.Items.IndexOf( CurrentChoice);
  if Combo.ItemIndex < 0 then Result := '';

  Frm.ShowModal;
  if Frm.ModalResult = mrOK then
     Result := Combo.Text;
  Combo.Free;
  Frm.Free;

end;

end.
