unit No_dbf;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, sctctrl, Sctvar, StdCtrls, Buttons, Sctbtn, Sctrep,
  ExtCtrls;

type
  TForm1 = class(TForm)
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    SctReportButton1: TSctReportButton;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    Counter: TSctExprvar;
    SctTextLabel1: TSctTextLabel;
    Square: TSctExprvar;
    Cube: TSctExprvar;
    TSctvarlabel: TSctvarlabel;
    TSctTextLabel: TSctTextLabel;
    TSctvarlabel1: TSctvarlabel;
    TSctTextLabel1: TSctTextLabel;
    TSctvarlabel2: TSctvarlabel;
    TSctTextLabel2: TSctTextLabel;
    procedure ReportPageDataStart(Sender: TObject);
    procedure ReportPageDataSkip(Sender: TObject);
    procedure CounterGetData(oVar: TSctvar);
    procedure ReportPageAfterDataSkip(page: TSctGrouppage);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  nCounter: Integer;

implementation

{$R *.DFM}

procedure TForm1.ReportPageDataStart(Sender: TObject);
begin
  { This event is responsible for positioning you to the first
    data item.  If none exist, then you should set DataIsFinished
    to True like we did in the DataSkip event below}
  nCounter := 1;
end;

procedure TForm1.ReportPageDataSkip(Sender: TObject);
var
  pg: TSctGrouppage;
begin
  if nCounter >= 20 Then
    begin
      { When we are done, we need to set the DataIsFinished flag
        to signal the report engine that we're done.}
      pg := TSctGroupPage(Sender);
      pg.DataIsFinished := True;
    end;
  nCounter := nCounter + 1;
end;

procedure TForm1.CounterGetData(oVar: TSctvar);
begin
  { The OnGetData event os where you normally will populate the
    expression variables.  If you are doing a nondatabase report
    you may find it more convenient and easier to understand if
    you use the OnAfterDataSkip event.}
  oVar.AsInteger := nCounter;
end;

procedure TForm1.ReportPageAfterDataSkip(page: TSctGrouppage);
begin
  { as an alternative to using the OnGetData event to fill
    in the values for expression variables, you can do it in
    the OnAfterDataSkip event.  This may be more convenient if you
    have multiple values to fill in.  For example, if you are using a
    different data engine or running over an array, it may make it
    easier to understand if you put all that interface code in one
    spot instead of spread out in the OnGetData events.}
  square.AsFloat := nCounter * nCounter;
  cube.AsFloat := nCounter * nCounter * nCounter;
end;

end.
