unit Db;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type

{$ifdef WIN32}
  TFieldType = (ftUnknown, ftString, ftSmallint, ftInteger, ftWord,
    ftBoolean, ftFloat, ftCurrency, ftBCD, ftDate, ftTime, ftDateTime,
    ftBytes, ftVarBytes, ftAutoInc, ftBlob, ftMemo, ftGraphic,
    ftFmtMemo, ftParadoxOle, ftDBaseOle, ftTypedBinary);
{$else}
TFieldType = (ftUnknown, ftString, ftSmallint, ftInteger, ftWord, ftBoolean, ftFloat,
  ftCurrency, ftBCD, ftDate, ftTime, ftDateTime, ftBytes, ftVarBytes, ftBlob, ftMemo,
  ftGraphic);
{$endif}

  TDatasource = class;
  TFieldDefs = class;
  TField = class;

  TDataChangeEvent = procedure(Sender: TObject; Field: TField) of object;

  TDataLink = class(TObject)
  private
  protected
  public
    DataSource: TDataSource;
    OnDataChange: TDataChangeEvent;
    procedure ActiveChanged; virtual;
  end;


  TDataSet = class(TComponent)
  private
    { Private declarations }
    FFields: TField;
  protected
    { Protected declarations }
    function GetField(Index: Integer): TField; virtual; abstract;
    procedure SetField(Index: Integer; Value: TField); virtual; abstract;
  public
    { Public declarations }
    Active: Boolean;
    Eof: Boolean;
    RecordCount: LongInt;
    FieldDefs: TFieldDefs;
    FieldCount: Integer;
    property Fields[Index: Integer]: TField read GetField write SetField;
    procedure First; virtual; abstract;
    procedure Next; virtual; abstract;
    procedure GetFieldNames(List: TStrings); virtual; abstract;
    function FieldByName(const FieldName: string): TField; virtual; abstract;
    function FindField(const FieldName: string): TField; virtual; abstract;
  end;

  TQuery = class(TDataSet)
  public
  end;

  TDataSource = class(TComponent)
  private
    FDataSet: TDataSet;
  public
  published
    property DataSet: TDataSet read FDataSet write FDataSet;
  end;

  TField = class(TComponent)
  private
  protected
  public
    DataType: TFieldType;
    AsString: String;
    AsFloat: Double;
    AsInteger: LongInt;
    AsBoolean: Boolean;
    AsDateTime: TDateTime;
    IsNull: Boolean;
    FieldName: String;
    DisplayLabel: String;
    Alignment: TAlignment;
    DisplayWidth: Integer;
  published
  end;

  TStringField = class(TField)
  public
    EditMask: String;
  end;

  TIntegerField = class(TField)
  public
    DisplayFormat: String;
  end;
  TWordField = class(TIntegerField)
  public
  end;
  TSmallIntField = class(TIntegerField)
  public
  end;
  TFloatField = class(TIntegerField)
  public
    Precision: Integer;
    Currency: Boolean;
  end;
  TCurrencyField = class(TFloatField)
  public
  end;
  TBooleanField = class(TField)
  end;
  TDateTimeField = class(TIntegerField)
  public
  end;
  TDateField = class(TDateTimeField)
  public
  end;
  TTimeField = class(TDateTimeField)
  public
  end;
  TMemoField = class(TField)
  public
  end;
  TGraphicField = class(TMemoField)
  public
  end;


  TFieldDef = class(TObject)
  private
  public
    DataType: TFieldType;
    function CreateField(DataSet: TDataSet): TField; virtual; abstract;
  end;

  TFieldDefs = class
  private
  public
    function Find(const Name: string): TFieldDef; virtual ;abstract;
    procedure Update; virtual; abstract;
  end;

  TBlobField = class(TField)
  private
  protected
  public
    procedure SaveToStream(Stream: TStream); virtual; abstract;
  published
  end;

implementation

procedure TDataLink.ActiveChanged;
begin
end;

end.