unit pmemo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SctVar, ExtCtrls, SctRep, StdCtrls, SctCtrl, Buttons, SctBtn;

type
  TMemoForm = class(TForm)
    MyMemo: TMemo;
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    SctReportButton1: TSctReportButton;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    MyMemoVar: TSctExprVar;
    varlabel: TSctvarlabel;
    procedure ReportPageDataStart(Sender: TObject);
    procedure ReportPageDataSkip(Sender: TObject);
    procedure MyMemoVarGetData(oVar: TSctVar);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MemoForm: TMemoForm;

implementation

{$R *.DFM}

procedure TMemoForm.ReportPageDataStart(Sender: TObject);
begin
  TSctPage(Sender).DataIsFinished := False;
end;

procedure TMemoForm.ReportPageDataSkip(Sender: TObject);
begin
  TSctPage(Sender).DataIsFinished := True;
end;

procedure StreamReplace(Stream: TMemoryStream; SearchList, ReplaceList: TStringList);
var
  S: TMemoryStream;
  Len, Spot: LongInt;
  MinLen, ReadLen: LongInt;

  SSpot: Integer;
  MyBuffer: array[0..10000] of Char;

  function FindStringInBuffer(Buffer: array of char; BufferLen: LongInt; Find: String): Integer;
  var
    bspot: Integer;
    flen: Integer;
    newstr: String;
  begin
    Result := -1;
    bspot := 0;
    flen := Length(Find);
    while bspot < BufferLen do
    begin
      if find[1] = Buffer[bspot] then
      begin
        newstr := Copy(Buffer, bSpot + 1, flen);
        if CompareStr(find, newstr) = 0 then
        begin
          Result := bSpot;
          bSpot := BufferLen;
        end else Inc(bSpot);
      end else Inc(bSpot);
    end;
  end;
  procedure SearchBuffer;
  var
    MySpot, SPos,AtPos, CurrPos : Integer;
    Temp: String;
  begin
    SPos := -1;
    AtPos := -1;
    for MySpot := 0 to SearchList.Count - 1 do
    begin
      CurrPos := FindStringInBuffer(MyBuffer, ReadLen, SearchList[MySpot]);
      if CurrPos <> -1 then
      begin
        if (CurrPos < AtPos) or (AtPos = -1) then
        begin
          SPos := MySpot;
          AtPos := CurrPos;
        end;
      end;
    end;
    if SPos <> -1 then
    begin
      S.Write(MyBuffer, AtPos);
      Temp := ReplaceList[SPos];
      S.Write(Pointer(Temp)^, Length(ReplaceList[SPos]));
      Spot := Spot + AtPos + Length(SearchList[SPos]);
    end else
    begin
      if ReadLen < 10000 then { Finished }
      begin
        S.Write(MyBuffer, ReadLen);
        Spot := Spot + ReadLen;
      end else
      begin
        S.Write(MyBuffer, ReadLen - MinLen);
        Spot := Spot + ReadLen - MinLen;
      end;
    end;
  end;
  procedure CheckMatch;
  begin
    ReadLen := 10000;
    Stream.Position := Spot;
    if (Len - Spot) < ReadLen then ReadLen := Len - Spot;
    ReadLen := Stream.Read(MyBuffer, ReadLen);
    if ReadLen = 0 then Spot := Len { end, where done }
    else
    begin
      SearchBuffer;
    end;
  end;
begin
  try
    S := TMemoryStream.Create;
    MinLen := 0;
    for Spot := 0 to SearchList.Count - 1 do
    begin
      if Length(SearchList[Spot]) > MinLen then MinLen := Length(SearchList[Spot]);
    end;

    Len := Stream.Size;
    Spot := 0;
    Stream.Position := 0;

    while (Spot < Len) do CheckMatch;

    { Copies entire stream }
    Stream.Clear;
    Stream.CopyFrom(S, 0);
    Stream.Position := 0;
  finally
    S.Free;
  end;
end;

procedure TMemoForm.MyMemoVarGetData(oVar: TSctVar);
var
  SearchList, ReplaceList: TStringList;
  Stream: TMemoryStream;
begin
  try
    SearchList := TStringList.Create;
    ReplaceList := TStringList.Create;
    Stream := TMemoryStream.Create;

    MyMemo.Lines.SaveToStream(Stream);
    SearchList.Add('$kevin$');
    SearchList.Add('$company$');
    ReplaceList.Add('k.maher');
    ReplaceList.Add('Sct Associates, Inc.');
    StreamReplace(Stream, SearchList, ReplaceList);
    oVar.AsStream := Stream;

  finally
    SearchList.Free;
    ReplaceList.Free;
    Stream.Free;
  end;
end;


end.
