unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SctCtrl, SctVar, AcePage, SctRep, ExtCtrls, StdCtrls,
  Buttons, SctBtn, Menus, Grids;

type
  PMyList = ^AList;
  AList = record
    X: Integer;
    Y: Integer;
    Rand: Integer;
    Text: String;
  end;

type
  TForm1 = class(TForm)
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    ExprVar: TSctExprVar;
    SctReportButton1: TSctReportButton;
    CheckBox1: TCheckBox;
    RadioGroup1: TRadioGroup;
    MultBand: TSctSubBand;
    Div1Band: TSctSubBand;
    Div2Band: TSctSubBand;
    varlabel2: TSctvarlabel;
    varlabel1: TSctvarlabel;
    varlabel: TSctvarlabel;
    SctLine2: TSctLine;
    SctLine1: TSctLine;
    varlabel3: TSctvarlabel;
    varlabel4: TSctvarlabel;
    varlabel5: TSctvarlabel;
    SctLine3: TSctLine;
    Sctvarlabel1: TSctvarlabel;
    Sctvarlabel2: TSctvarlabel;
    Sctvarlabel3: TSctvarlabel;
    Sctvarlabel4: TSctvarlabel;
    SctLine4: TSctLine;
    Sctvarlabel5: TSctvarlabel;
    Button1: TButton;
    ExprX: TSctExprVar;
    ExprY: TSctExprVar;
    ListBox1: TListBox;
    procedure ExprVarGetData(oVar: TSctVar);
    procedure ReportPageBeforeNewPage(Page: TSctPage;
      var DoNewPage: Boolean);
    procedure SctReport1BeforePrint(Report: TSctReport);
    procedure DetailBandBeforePrint(Band: TSctBand);
    procedure ShowAnswers(lb: TSctLabel; var Result: Boolean);
    procedure SelectReport(Band: TSctBand; var Result: Boolean);
    procedure MakeList(Sender: TObject);
    procedure ReportPageDataStart(Sender: TObject);
    procedure ReportPageDataSkip(Sender: TObject);
    procedure ReportPageDataFilter(Sender: TObject; var Result: Boolean);

  private
    { Private declarations }
  public
    { Public declarations }
    ProblemList: TList;
    Cnt: Integer;
  end;

  function MySort( a, b:Pointer ):Integer;

var
  Form1: TForm1;

implementation
var
  MarkYPos, nCols, nColWidth, nCurrCol: Integer;

{$R *.DFM}

procedure TForm1.ExprVarGetData(oVar: TSctVar);
begin
  oVar.AsInteger :=  ExprX.AsInteger * ExprY.AsInteger;
end;

procedure TForm1.ReportPageBeforeNewPage(Page: TSctPage;
  var DoNewPage: Boolean);
begin
  Inc(nCurrCol);
  DoNewPage := (nCurrCol >= nCols);
  if DoNewPage then nCurrCol := 0 else Page.yPos := MarkYPos;

  Page.xPos := Round(Page.PageSetup.LeftMargin * Page.PixelsPerInch)
              + (nCurrCol * nColWidth);
end;

procedure TForm1.SctReport1BeforePrint(Report: TSctReport);
begin
  if ProblemList = nil then MakeList(Report);
  if RadioGroup1.ItemIndex = 1
     then nCols := 8
     else nCols := 13;
  nColWidth := Report.Page.PageWidth div nCols;
  nCurrCol := 0;
  MarkYPos := -1;
end;

procedure TForm1.DetailBandBeforePrint(Band: TSctBand);
begin
  if MarkYPos = -1 then MarkYPos :=  Band.Page.YPos;
end;

procedure TForm1.ShowAnswers(lb: TSctLabel;
  var Result: Boolean);
begin
  Result := CheckBox1.Checked;
end;

procedure TForm1.SelectReport(Band: TSctBand; var Result: Boolean);
begin
  Result := (RadioGroup1.ItemIndex = Band.Tag);
end;

procedure TForm1.MakeList(Sender: TObject);
var
  x,y: Integer;
  Arecord: PMyList;
begin
  ProblemList.Free;
  ProblemList := TList.Create;
  ListBox1.Items.Clear;
  Randomize();
  with ProblemList do begin
    for x := 0 to 12 do begin
      for y := 0 to 12 do begin
        New(Arecord);
        Arecord^.X := x;
        Arecord^.Y := y;
        Arecord^.Rand := Random(1000);
        Arecord^.Text := IntToStr(x) + ' x ' + IntToStr(y) +' = ' + IntToStr(x*y);
        Add(Arecord);
      end;
    end;
    Sort( MySort);
    for x := 1 to problemList.Count do
        ListBox1.Items.Add(PMyList(ProblemList.Items[x-1])^.Text);
  end;
end;

function MySort( a, b:Pointer ) : Integer;
begin
  Result := PMylist(a)^.Rand - PMyList(b)^.Rand;
end;

procedure TForm1.ReportPageDataStart(Sender: TObject);
begin
  Cnt := 0;
end;

procedure TForm1.ReportPageDataSkip(Sender: TObject);
begin
  Inc(Cnt);
  TSctPage(Sender).DataIsFinished := (Cnt >= ProblemList.Count);
end;

procedure TForm1.ReportPageDataFilter(Sender: TObject;
  var Result: Boolean);
var
  Rec: PMyList;
begin
  Rec := ProblemList.Items[Cnt];
  ExprX.AsInteger := Rec^.X;
  ExprY.AsInteger := Rec^.Y;
  Result := (RadioGroup1.ItemIndex = 0) or not (Rec^.X * Rec^.Y = 0);
end;

end.
