unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SctRep, Menus, SctVar, ExtCtrls, StdCtrls, Buttons, SctBtn, SctCtrl;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Memo2: TMemo;
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    Data: TSctSubDataBand;
    DataLevel: TSctLevel;
    Group: TSctGroup;
    GroupHeader: TSctBand;
    GroupHeaderLevel: TSctLevel;
    GroupFooter: TSctBand;
    GroupFooterLevel: TSctLevel;
    OrdNumVar: TSctExprVar;
    Sctvarlabel1: TSctvarlabel;
    SctReportButton1: TSctReportButton;
    TotalOfLBLVar: TSctTotalvar;
    LabelVar: TSctExprVar;
    varlabel: TSctvarlabel;
    Sctvarlabel2: TSctvarlabel;
    Sctvarlabel3: TSctvarlabel;
    Memo3: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    LineNumVar: TSctExprVar;
    Sctvarlabel4: TSctvarlabel;
    varlabel1: TSctvarlabel;
    SctShape1: TSctShape;
    procedure ReportPageDataStart(Sender: TObject);
    procedure ReportPageDataSkip(Sender: TObject);
    procedure OrdNumVarGetData(oVar: TSctVar);
    procedure DataDataStart(Sender: TObject);
    procedure DataDataSkip(Sender: TObject);
    procedure LabelVarGetData(oVar: TSctVar);
    procedure LineNumVarGetData(oVar: TSctVar);
    procedure DataBeforePrint(Band: TSctBand);
    procedure SctReport1BeforePrint(Report: TSctReport);
    procedure ReportPageBeforeNewPage(Page: TSctPage;
      var DoNewPage: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    RecPos: integer;
    LblCnt: integer ;
    Col, MarkYPos: Integer;
    LastRow: Boolean;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses SCTDATA;

procedure TForm1.ReportPageDataStart(Sender: TObject);
begin
  RecPos := 0;
  (Sender as TSctPage).DataIsFinished := (RecPos >= (Memo1.Lines.Count-1));
end;

procedure TForm1.ReportPageDataSkip(Sender: TObject);
begin
  Inc(RecPos);
  (Sender as TSctPage).DataIsFinished := (RecPos >= (Memo1.Lines.Count-1));
end;

procedure TForm1.OrdNumVarGetData(oVar: TSctVar);
begin
  oVar.AsString := Memo1.Lines[RecPos];
end;

procedure TForm1.DataDataStart(Sender: TObject);
begin
  LblCnt := 1;
  (Sender as TSctSubDataBand).DataIsFinished :=
     (LblCnt > StrToInt(Memo2.Lines[RecPos]));
end;

procedure TForm1.DataDataSkip(Sender: TObject);
begin
  Inc(LblCnt);
  (Sender as TSctSubDataBand).DataIsFinished :=
     (LblCnt > StrToInt(Memo2.Lines[RecPos]));
end;

procedure TForm1.LabelVarGetData(oVar: TSctVar);
begin
  oVar.AsString := Chr(64 + TotalOfLBLVar.GetLevel(GroupFooterLevel,ttCount).AsInteger);
end;

procedure TForm1.LineNumVarGetData(oVar: TSctVar);
begin
  oVar.AsInteger := StrToInt(Memo3.Lines[RecPos]);
end;

procedure TForm1.DataBeforePrint(Band: TSctBand);
begin
  band.page.xPos := Trunc(band.page.pagesetup.LeftMargin *
                    band.page.pixelsperinch) + Col * 200;
  if (Col > 0) and (not LastRow) then  band.page.YPos := MarkYPos;
  Inc(Col);
  if Col > 2 then Col := 0;
  MarkYPos := band.page.YPos;
end;

procedure TForm1.SctReport1BeforePrint(Report: TSctReport);
begin
  Col := 0;
  LastRow := False;
end;

procedure TForm1.ReportPageBeforeNewPage(Page: TSctPage;
  var DoNewPage: Boolean);
begin
  DoNewPage := (Col = 0);
  if not DoNewPage then Page.YPos := MarkYPos
    else Page.xPos := Trunc(page.pagesetup.LeftMargin *
                    page.pixelsperinch);
  LastRow := not DoNewPage;
end;

end.
