unit RptOut;

interface

uses AceOut
{$ifdef WIN32}
  ,windows;
{$else}
  ,winprocs, wintypes;
{$endif}

type

TMyOutput = class(TAceOutput)
private
protected
public
  { Margin is in inches }
  LeftMargin, TopMargin, RightMargin, BottomMargin: Double;
  xPos, yPos: Double;
  LineGap: Double;
  constructor Create;
  procedure MyBegin;
  function LineSize: Double;
  function ColumnSize: Double;
  function LinesPerPage: Integer;
  function ColumnsPerPage: Integer;
  procedure NextLine;
  procedure MyNewPage;

  function PageEnd: Double;

end;

implementation

uses printers;

constructor TMyOutput.Create;
begin
  inherited Create;
  LeftMargin := 0.5;
  TopMargin := 0.5;
  RightMargin := 0.5;
  BottomMargin := 0.5;
  LineGap := 0.05
end;

procedure TMyOutput.MyBegin;
begin
  { Set resolution to printers so everything can be
    formated to the printer and not the screen }
  PixelsPerInchX := AcePrinterSetup.PixelsPerInchX;
  PixelsPerInchY := AcePrinterSetup.PixelsPerInchY;

  xPos := LeftMargin;
  yPos := TopMargin;

  BeginDoc;
end;

function TMyOutput.LineSize: Double;   { Line height in pixels }
begin
  Result := AceCanvas.Font.Size / 72 + LineGap;
end;

function TMyOutput.ColumnSize: Double; { Column width in pixels }
var
  Metrics: TTextMetric;
  DC, SaveDC: THandle;
begin
  if AcePrinterSetup.PrinterCount > 0 then
  begin
    if (Destination = adPrinter) then
    begin
      GetTextMetrics(Handle, Metrics);
    end else
    begin
      DC := Printers.Printer.Handle;

      SaveDC := windows.SaveDC(DC);

      { Set Current Font }
      SelectObject(DC, AceCanvas.SelectFont);
      GetTextMetrics(DC, Metrics);
      RestoreDC(DC, SaveDC);
    end;
    Result := Metrics.tmAveCharWidth / PixelsPerInchX;
  end else Result := 0.1;
end;

function TMyOutput.LinesPerPage: Integer;
begin
  Result := Round((AcePrinterSetup.Length-(TopMargin+BottomMargin)) / LineSize);
end;

function TMyOutput.ColumnsPerPage: Integer;
begin
  Result := Round((AcePrinterSetup.Width-(LeftMargin+RightMargin)) / ColumnSize);
end;

procedure TMyOutput.NextLine;
begin
  yPos := yPos + LineSize;
end;

procedure TMyOutput.MyNewPage;
begin
  xPos := LeftMargin;
  yPos := TopMargin;

  NewPage;
end;

function TMyOutput.PageEnd: Double;
begin
  Result := AcePrinterSetup.Length - BottomMargin;
end;

end.
