unit dupdata;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, SctCtrl, SctRep, Menus, SctVar, AcePage, DB, DBTables, ExtCtrls,
  StdCtrls, Buttons, SctBtn;

type
  Tdupdataform = class(TForm)
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    DataSource1: TDataSource;
    Query1: TQuery;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    DataSourceGuide: TSctDataSourceGuide;
    query1LAST_NAMEVar: TSctDBVar;
    query1FIRST_NAMEVar: TSctDBVar;
    query1CITYVar: TSctDBVar;
    query1STATEVar: TSctDBVar;
    Group: TSctGroup;
    GroupHeader: TSctBand;
    GroupHeaderLevel: TSctLevel;
    GroupFooter: TSctBand;
    GroupFooterLevel: TSctLevel;
    TotalOfSTATE: TSctTotalvar;
    Data: TSctSubDataBand;
    DataLevel: TSctLevel;
    Data1: TSctSubDataBand;
    Data1Level: TSctLevel;
    varlabel: TSctvarlabel;
    varlabel1: TSctvarlabel;
    varlabel2: TSctvarlabel;
    varlabel3: TSctvarlabel;
    varlabel5: TSctvarlabel;
    TotalvarLabel: TSctTotalvarLabel;
    SctReportButton1: TSctReportButton;
    Memo1: TMemo;
    procedure DataDataStart(Sender: TObject);
    procedure DataDataSkip(Sender: TObject);
    procedure DataBeforePrint(Band: TSctBand);
    procedure DataAfterPrint(Band: TSctBand);
  private
    { Private declarations }
    DupPos: integer;
  public
    { Public declarations }
  end;

var
  dupdataform: Tdupdataform;

implementation

{$R *.dfm}

procedure Tdupdataform.DataDataStart(Sender: TObject);
begin
  DupPos := 0;
  (Sender as TSctSubDataBand).DataIsFinished := (DupPos > 1);
end;

procedure Tdupdataform.DataDataSkip(Sender: TObject);
begin
  Inc(DupPos);
  (Sender as TSctSubDataBand).DataIsFinished := (DupPos > 1)
end;

procedure MoveLabels(Band: TSctBand; Offset: integer);
var
  i: integer;
  lb: TSctLabel;
begin
  i := Band.Labels.Count -1;
  while (i >= 0) do
  begin
    lb := Band.Labels.Items[i];
    lb.Top := lb.Top + Offset;
    Dec(i);
  end;
end;

procedure Tdupdataform.DataBeforePrint(Band: TSctBand);
begin
  // note we are only printing twice, so first time height will be zero
  // and second time will be desired height.  If you print more than 2 times
  // you will want to use if/then logic instead
  Band.Height := DupPos * 20;
  if DupPos = 1 then MoveLabels(Band,300);
end;

procedure Tdupdataform.DataAfterPrint(Band: TSctBand);
begin
  if DupPos = 1 then  MoveLabels(Band,-300);
end;

end.
