unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SctCtrl, SctVar, AcePage, SctRep, Db, DBTables, ExtCtrls,
  Buttons, SctBtn;

type
  TForm1 = class(TForm)
    SctReport1: TSctReport;
    ReportPage: TSctGrouppage;
    ReportHeaderBand: TSctBand;
    ReportHeaderBandlevel: TSctLevel;
    PageHeaderBand: TSctBand;
    PageHeaderBandlevel: TSctLevel;
    DetailBand: TSctBand;
    DetailBandlevel: TSctLevel;
    PageFooterBand: TSctBand;
    PageFooterBandlevel: TSctLevel;
    ReportFooterBand: TSctBand;
    ReportFooterBandlevel: TSctLevel;
    DataSource1: TDataSource;
    Table1: TTable;
    svarDateTime: TSctDateTimeVar;
    svarPage: TSctPageVar;
    DataSourceGuide: TSctDataSourceGuide;
    table1LAST_NAMEVar: TSctDBVar;
    table1FIRST_NAMEVar: TSctDBVar;
    varlabel: TSctvarlabel;
    varlabel1: TSctvarlabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    function AddSub(Page: TSctPage; bd:TSctBand; name: String): TSctSubBand;
    function CreateVarLabel(Page: TSctPage; Band: TSctBand): TSctVarLabel;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses sctutil;

procedure TForm1.Button1Click(Sender: TObject);
var
  pg: TSctPage;
  bd: TSctBand;
  Lab: TSctVarLabel;
begin
  ShowMessage('Here is original Report');
  SctReport1.Run;

  {Lets add the Subband and a label}
  pg := SctReport1.Page;
  bd := AddSub(pg,pg.Detail,'Sub1');
  Lab := CreateVarLabel(pg,bd);
  Lab.Caption := 'Test 1';

  ShowMessage('Here is report after adding subband');
  SctReport1.Run;
  TButton(Sender).Enabled := False;  {Disable after band has been added}
end;

function TForm1.AddSub(Page: TSctPage; bd:TSctBand; name: String): TSctSubBand;
begin
  try
    Result := TSctSubBand.Create(Page.Owner);
    if SctAutoSetComponentName(Result, name,False) then
    begin
      Result.Parent := TSctGroupPage(Page);
      Result.Band := bd;
      Result.height := 20;
      Result.Top := 0;
      Result.width := 200;
      Result.bandname := Result.Name;
      Result.UpdateLevel := bd.UpdateLevel;
      Result.Above := False;
    end else Raise Exception.Create('Could not create band.');
  except
    if Result <> nil then Result.Free;
  end;
end;

function TForm1.CreateVarLabel(Page: TSctPage; Band: TSctBand): TSctVarLabel;
begin
  Result := TSctVarLabel.Create(Page.Owner);
  with Result do
  begin
    Parent := Band;
    AutoSize := False;
    Font.Name := 'Arial';
    Font.Size := 8;
  end;
end;
end.
