unit wm;

interface

uses
  SysUtils, Classes, HTTPApp;

type
  TWebModule1 = class(TWebModule)
    procedure WebModule1defaultAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1runAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1formAction(Sender: TObject; Request: TWebRequest;
      Response: TWebResponse; var Handled: Boolean);
  private
    function UniqueName: String;
    function ModuleFileName: String;
    function currpath: String;
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

uses windows,comobj,activex,SCTRep,PSetup,Aceout, Rbio;
{$R *.DFM}

procedure NullStat(Page: TSctPage);
var Msg: TMsg;
begin
  if PeekMessage(Msg, 0, 0, 0, PM_REMOVE) then
    begin
    TranslateMessage(Msg);
    DispatchMessage(Msg);
    end;
end;

function TWebModule1.currpath: String;
begin
  Result := ExtractFilePath(ModuleFileName);
end;

function TWebModule1.ModuleFileName: String;
var FileName : array[0..MAX_PATH] of char;
begin
  FillChar(FileName, sizeof(FileName), 0);
  GetModuleFileName(hInstance, FileName, sizeof(FileName));
  Result := FileName;
end;

function TWebModule1.UniqueName: String;
var Guid: TGUID;
begin
  OleCheck(CoCreateGuid(Guid));
  Result := GUIDToString(Guid);
  Result := Copy(Result,2,Length(Result)-2);
  While Pos('-',Result)>0 do
    Delete(Result,Pos('-',Result),1);
end;

procedure TWebModule1.WebModule1defaultAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.SendRedirect('http://'+Request.Host+Request.ScriptName+'/form');
end;

procedure TWebModule1.WebModule1formAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
const spcs='&nbsp;&nbsp;&nbsp;';
begin
  Response.Content := '<html><body>'+
     '<form action="run" method="post">'+
     ' Choose report type:'+
     '<input name="rptType" type="radio" checked value="ace">Ace'+spcs+
     '<input name="rptType" type="radio" value="html">Html'+spcs+
     '<input name="rptType" type="radio" value="rtf">RTF'+spcs+
     '<input name="rptType" type="radio" value="pdf">PDF'+spcs+
     '<input name="rptType" type="radio" value="txt">Text'+spcs+
     '<input name="rptType" type="radio" value="excel">Excel'+spcs+
     '<input name="rptType" type="radio" value="gif">Gif'+spcs+
     '<input name="rptType" type="radio" value="jpg">Jpeg'+spcs+
     '<input name="rptType" type="radio" value="bmp">Bmp'+spcs+
     '<input name="rptType" type="radio" value="emp">Emp'+spcs+
     '<input name="rptType" type="radio" value="wmf">Wmf'+spcs+
     '<br><input type="submit" value="Run Ace Report">'+
     '</form>'+
     '</body></html>';
end;

procedure TWebModule1.WebModule1runAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var acefile, rptType: String;
begin
  If FileGetAttr(currpath+'/acemeta')<>16 then
    Response.Content := 'Please make dir:'+currpath+'\acemeta'
  else
    begin
    rptType := Request.ContentFields.Values['rptType'];
    acefile := UniqueName+'.ace';
    with TMemoReport.Create(self) do
      try
      TSctGrouppage1.AceFileName := currpath+'AceMeta\'+acefile;
      TSctGrouppage1.PageSetup.Destination := destFile;
      rmemo.Prompt := False;
      SctRep.CustomStatus := NullStat;
      rmemo.Run;
      If (rptType='') or (rptType='ace') then
        Response.SendRedirect('../AcePack.dll?ace='+acefile)
      else
        Response.SendRedirect('../AceHtml.exe?ace='+acefile+'&type='+rptType);
      except
        on e: exception do
         Response.Content := 'Error occured'+#13+E.message;
      end;
    end;
end;


end.
