unit ZibUtil;

interface
uses Classes,zlib;
procedure CompressStream(Instream,CompStream: TStream;CL:TCompressionLevel=clDefault);
procedure DeCompressStream(Instream,DeCompStream: TStream);
function CompressFile(FileName,CompressTo: String;CL:TCompressionLevel=clDefault): Boolean;
function DeCompressFile(FileName,DeCompressTo: String): Boolean;

implementation

uses SysUtils;
procedure CompressStream(Instream,CompStream: TStream;CL:TCompressionLevel=clDefault);
var CompressionStream: TCompressionStream;
begin
  Instream.Position := 0;
  CompStream.Position := 0;
  CompressionStream := TCompressionStream.Create(CL,CompStream);
  try
  CompressionStream.CopyFrom(Instream,0);
  finally
  CompressionStream.Free;
  end;
end;

procedure DeCompressStream(Instream,DeCompStream: TStream);
var          Buffer: Array[0..4095] of Char;
             BufLen: Integer;
DecompressionStream: TDecompressionStream;
begin
  DecompressionStream := TDecompressionStream.Create(Instream);
  try
  BufLen := DecompressionStream.Read(Buffer,SizeOf(Buffer));
  while BufLen > 0 do
    begin
    DeCompStream.Write(Buffer,BufLen);
    BufLen := DecompressionStream.Read(Buffer,SizeOf(Buffer));
    end;
  finally
  DecompressionStream.Free;
  end;
end;

function CompressFile(FileName,CompressTo: String;CL:TCompressionLevel): Boolean;
var      FileStream: TStream;
     CompFileStream: TStream;
  CompressionStream: TCompressionStream;
begin
  If FileExists(CompressTo) and not DeleteFile(CompressTo) then
    begin
    result := False;
    exit;
    end;
  if FileExists(FileName) then
    try
    FileStream := TFileStream.Create(FileName,fmOpenRead OR fmShareDenyWrite);
    CompFileStream := TFileStream.Create(CompressTo,fmCreate);
    CompFileStream.Position :=0;
    CompressionStream := TCompressionStream.Create(CL,CompFileStream);
    CompressionStream.CopyFrom(FileStream,0);
    finally
    CompressionStream.Free;
    CompFileStream.Free;
    FileStream.Free;
    Result := True;
    end
  else Result := False;
end;

function DeCompressFile(FileName,DeCompressTo: String):Boolean;
var          Buffer: Array[0..4095] of Char;
             BufLen: Integer;
         FileStream: TStream;
     CompFileStream: TStream;
DecompressionStream: TDecompressionStream;
begin
  If FileExists(DeCompressTo) and not DeleteFile(DeCompressTo) then
    begin
    result := False;
    exit;
    end;
  if FileExists(FileName) then
    try
    CompFileStream := TFileStream.Create(FileName,fmOpenRead OR fmShareDenyWrite);
    FileStream := TFileStream.Create(DeCompressTo,fmCreate);
    FileStream.Position := 0;
    DecompressionStream := TDecompressionStream.Create(CompFileStream);
    BufLen := DecompressionStream.Read(Buffer,SizeOf(Buffer));
    while BufLen > 0 do
      begin
      FileStream.Write(Buffer,BufLen);
      BufLen := DecompressionStream.Read(Buffer,SizeOf(Buffer));
      end;
    finally
    DecompressionStream.Free;
    FileStream.Free;
    CompFileStream.Free;
    Result := True;
    end;
end;
end.
