unit AceViewerImpl;
{$WARN SYMBOL_PLATFORM OFF}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ActiveX, AxCtrls, AceViewer_TLB, StdVcl, Buttons, ComCtrls, ToolWin,
  ImgList, AcePrev, ExtCtrls, StdCtrls,AceFile, AceSetup,urlmon;

type
  TAceViewerMode = set of (vmGenerating, vmPrinting);
  TAceViewerX = class(TActiveForm, IAceViewerX,IPersistPropertyBag)
    ToolBar: TToolBar;
    ZoomFit: TToolButton;
    ZoomToWidth: TToolButton;
    ZoomToHeight: TToolButton;
    Zoomin: TToolButton;
    ZoomOut: TToolButton;
    Separator3: TToolButton;
    SaveReport: TToolButton;
    LoadReport: TToolButton;
    Separator4: TToolButton;
    PrintSetup: TToolButton;
    Printbtn: TToolButton;
    Separator2: TToolButton;
    ExitButton: TSpeedButton;
    Stop: TSpeedButton;
    AcePreview: TAcePreview;
    SB: TScrollBar;
    OpenFileDialog: TOpenDialog;
    Images: TImageList;
    SaveFileDialog: TSaveDialog;
    PrinterSetup: TPrinterSetupDialog;
    pageSize: TLabel;
    ToolButton1: TToolButton;
    Zoom100: TToolButton;
    procedure LoadReportClick(Sender: TObject);
    procedure SaveReportClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure PrintSetupClick(Sender: TObject);
    procedure ZoomFitClick(Sender: TObject);
    procedure ZoomClick(Sender: TObject);
    procedure ActiveFormCreate(Sender: TObject);
    procedure PrintbtnClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure SBChange(Sender: TObject);
  private
    { Private declarations }
    FEvents: IAceViewerXEvents;
    ShowFirst: Boolean;
    FGenerating: Boolean;
    FViewerMode: TAceViewerMode;
    FSrc: String;
    procedure SetGenerating( Value: Boolean);
    procedure ActivateEvent(Sender: TObject);
    procedure ClickEvent(Sender: TObject);
    procedure CreateEvent(Sender: TObject);
    procedure DblClickEvent(Sender: TObject);
    procedure DeactivateEvent(Sender: TObject);
    procedure DestroyEvent(Sender: TObject);
    procedure KeyPressEvent(Sender: TObject; var Key: Char);
    procedure PaintEvent(Sender: TObject);
    function  sPaperSize(PaperSize: Integer): String;
  protected
    {implement IPersistPropertyBag}
    function IPersistPropertyBag.GetClassID =PersistPropertyBagGetClassID;
    function IPersistPropertyBag.InitNew = PersistPropertyBagInitNew;
    function IPersistPropertyBag.Load = PersistPropertyBagLoad;
    function IPersistPropertyBag.Save = PersistPropertyBagSave;
    function PersistPropertyBagInitNew: HResult; stdcall;
    function PersistPropertyBagGetClassID(out classID: TCLSID): HResult;stdcall;
    function PersistPropertyBagLoad(const pPropBag: IPropertyBag; const pErrorLog: IErrorLog): HResult; stdcall;
    function PersistPropertyBagSave(const pPropBag: IPropertyBag;fClearDirty: BOOL; fSaveAllProperties: BOOL): HResult; stdcall;
    { Protected declarations }
    procedure DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage); override;
    procedure EventSinkChanged(const EventSink: IUnknown); override;
    function Get_Active: WordBool; safecall;
    function Get_AutoScroll: WordBool; safecall;
    function Get_AutoSize: WordBool; safecall;
    function Get_AxBorderStyle: TxActiveFormBorderStyle; safecall;
    function Get_Caption: WideString; safecall;
    function Get_Color: OLE_COLOR; safecall;
    function Get_Cursor: Smallint; safecall;
    function Get_DoubleBuffered: WordBool; safecall;
    function Get_DropTarget: WordBool; safecall;
    function Get_Enabled: WordBool; safecall;
    function Get_Font: IFontDisp; safecall;
    function Get_HelpFile: WideString; safecall;
    function Get_KeyPreview: WordBool; safecall;
    function Get_PixelsPerInch: Integer; safecall;
    function Get_PrintScale: TxPrintScale; safecall;
    function Get_Scaled: WordBool; safecall;
    function Get_Visible: WordBool; safecall;
    function Get_VisibleDockClientCount: Integer; safecall;
    procedure _Set_Font(var Value: IFontDisp); safecall;
    procedure Set_AutoScroll(Value: WordBool); safecall;
    procedure Set_AutoSize(Value: WordBool); safecall;
    procedure Set_AxBorderStyle(Value: TxActiveFormBorderStyle); safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    procedure Set_Color(Value: OLE_COLOR); safecall;
    procedure Set_Cursor(Value: Smallint); safecall;
    procedure Set_DoubleBuffered(Value: WordBool); safecall;
    procedure Set_DropTarget(Value: WordBool); safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    procedure Set_Font(const Value: IFontDisp); safecall;
    procedure Set_HelpFile(const Value: WideString); safecall;
    procedure Set_KeyPreview(Value: WordBool); safecall;
    procedure Set_PixelsPerInch(Value: Integer); safecall;
    procedure Set_PrintScale(Value: TxPrintScale); safecall;
    procedure Set_Scaled(Value: WordBool); safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Src: WideString; safecall;
    procedure LoadFile(const filename: WideString); safecall;
    procedure Print; safecall;
  public
    { Public declarations }
    procedure Initialize; override;
    function GetLoadPercent: Single;
    procedure UpdatePage;
    property Generating: Boolean read FGenerating write SetGenerating;
  end;

implementation

uses ComObj, ComServ,printers, aceout, clipbrd, acedest, acepstat, acegoto,
     aceutil, sctconst,variants,zlib;

{$R *.DFM}

{ TAceViewerX }

procedure TAceViewerX.DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage);
begin
  { Define property pages here.  Property pages are defined by calling
    DefinePropertyPage with the class id of the page.  For example,
      DefinePropertyPage(Class_AceViewerXPage); }
end;

procedure TAceViewerX.EventSinkChanged(const EventSink: IUnknown);
begin
  FEvents := EventSink as IAceViewerXEvents;
end;

procedure TAceViewerX.Initialize;
begin
  inherited Initialize;
  OnActivate := ActivateEvent;
  OnClick := ClickEvent;
  OnCreate := CreateEvent;
  OnDblClick := DblClickEvent;
  OnDeactivate := DeactivateEvent;
  OnDestroy := DestroyEvent;
  OnKeyPress := KeyPressEvent;
  OnPaint := PaintEvent;
end;

function TAceViewerX.Get_Active: WordBool;
begin
  Result := Active;
end;

function TAceViewerX.Get_AutoScroll: WordBool;
begin
  Result := AutoScroll;
end;

function TAceViewerX.Get_AutoSize: WordBool;
begin
  Result := AutoSize;
end;

function TAceViewerX.Get_AxBorderStyle: TxActiveFormBorderStyle;
begin
  Result := Ord(AxBorderStyle);
end;

function TAceViewerX.Get_Caption: WideString;
begin
  Result := WideString(Caption);
end;

function TAceViewerX.Get_Color: OLE_COLOR;
begin
  Result := OLE_COLOR(Color);
end;

function TAceViewerX.Get_Cursor: Smallint;
begin
  Result := Smallint(Cursor);
end;

function TAceViewerX.Get_DoubleBuffered: WordBool;
begin
  Result := DoubleBuffered;
end;

function TAceViewerX.Get_DropTarget: WordBool;
begin
  Result := DropTarget;
end;

function TAceViewerX.Get_Enabled: WordBool;
begin
  Result := Enabled;
end;

function TAceViewerX.Get_Font: IFontDisp;
begin
  GetOleFont(Font, Result);
end;

function TAceViewerX.Get_HelpFile: WideString;
begin
  Result := WideString(HelpFile);
end;

function TAceViewerX.Get_KeyPreview: WordBool;
begin
  Result := KeyPreview;
end;

function TAceViewerX.Get_PixelsPerInch: Integer;
begin
  Result := PixelsPerInch;
end;

function TAceViewerX.Get_PrintScale: TxPrintScale;
begin
  Result := Ord(PrintScale);
end;

function TAceViewerX.Get_Scaled: WordBool;
begin
  Result := Scaled;
end;

function TAceViewerX.Get_Visible: WordBool;
begin
  Result := Visible;
end;

function TAceViewerX.Get_VisibleDockClientCount: Integer;
begin
  Result := VisibleDockClientCount;
end;

procedure TAceViewerX._Set_Font(var Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TAceViewerX.ActivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnActivate;
end;

procedure TAceViewerX.ClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnClick;
end;

procedure TAceViewerX.CreateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnCreate;
end;

procedure TAceViewerX.DblClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDblClick;
end;

procedure TAceViewerX.DeactivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDeactivate;
end;

procedure TAceViewerX.DestroyEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDestroy;
end;

procedure TAceViewerX.KeyPressEvent(Sender: TObject; var Key: Char);
var
  TempKey: Smallint;
begin
  TempKey := Smallint(Key);
  if FEvents <> nil then FEvents.OnKeyPress(TempKey);
  Key := Char(TempKey);
end;

procedure TAceViewerX.PaintEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnPaint;
end;

procedure TAceViewerX.Set_AutoScroll(Value: WordBool);
begin
  AutoScroll := Value;
end;

procedure TAceViewerX.Set_AutoSize(Value: WordBool);
begin
  AutoSize := Value;
end;

procedure TAceViewerX.Set_AxBorderStyle(Value: TxActiveFormBorderStyle);
begin
  AxBorderStyle := TActiveFormBorderStyle(Value);
end;

procedure TAceViewerX.Set_Caption(const Value: WideString);
begin
  Caption := TCaption(Value);
end;

procedure TAceViewerX.Set_Color(Value: OLE_COLOR);
begin
  Color := TColor(Value);
end;

procedure TAceViewerX.Set_Cursor(Value: Smallint);
begin
  Cursor := TCursor(Value);
end;

procedure TAceViewerX.Set_DoubleBuffered(Value: WordBool);
begin
  DoubleBuffered := Value;
end;

procedure TAceViewerX.Set_DropTarget(Value: WordBool);
begin
  DropTarget := Value;
end;

procedure TAceViewerX.Set_Enabled(Value: WordBool);
begin
  Enabled := Value;
end;

procedure TAceViewerX.Set_Font(const Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TAceViewerX.Set_HelpFile(const Value: WideString);
begin
  HelpFile := String(Value);
end;

procedure TAceViewerX.Set_KeyPreview(Value: WordBool);
begin
  KeyPreview := Value;
end;

procedure TAceViewerX.Set_PixelsPerInch(Value: Integer);
begin
  PixelsPerInch := Value;
end;

procedure TAceViewerX.Set_PrintScale(Value: TxPrintScale);
begin
  PrintScale := TPrintScale(Value);
end;

procedure TAceViewerX.Set_Scaled(Value: WordBool);
begin
  Scaled := Value;
end;

procedure TAceViewerX.Set_Visible(Value: WordBool);
begin
  Visible := Value;
end;

function TAceViewerX.Get_Src: WideString;
begin
  Result := FSrc;
end;

procedure TAceViewerX.LoadFile(const filename: WideString);
var
  Buffer: Array[0..4095] of Char;
  BufLen: Integer;
  AceStream : TStream;
  CompFileStream: TStream;
  DecompressionStream: TDecompressionStream;
begin
  If FileExists(filename) then
    begin
    pageSize.Caption := '';
    FSrc := WideCharToString(PWideChar(filename));
    If LowerCase(ExtractFileExt(FSrc))='.acz' then
      try try
      CompFileStream := TFileStream.Create(FSrc,fmOpenRead OR fmShareDenyWrite);
      AceStream := TMemoryStream.Create;
      AceStream.Position := 0;
      DecompressionStream := TDecompressionStream.Create(CompFileStream);
      BufLen := DecompressionStream.Read(Buffer,SizeOf(Buffer));
      while BufLen > 0 do
        begin
        AceStream.Write(Buffer,BufLen);
        BufLen := DecompressionStream.Read(Buffer,SizeOf(Buffer));
        end;
      AceStream.Position := 0;
      AcePreview.LoadFromStream(AceStream);
      Zoom100.Down := AcePreview.Zoom=100;
      except
        On E: Exception do
          MessageBox(GetParent(Handle),PChar('Extract file error on '+FSrc+'.'#$D#$A'Error message:'+E.Message),'Error',MB_OK+MB_ICONERROR);
      end;
      finally
      DecompressionStream.Free;
      AceStream.Free;
      CompFileStream.Free;
      end
    else
      try
      AcePreview.LoadFromFile(FSrc);
      except
        On E: Exception do
          MessageBox(GetParent(Handle),PChar('Load file error on '+FSrc+'.'#$D#$A'Error Message:'+E.Message),'~',MB_OK+MB_ICONERROR);
      end;
    UpdatePage;
    pageSize.Caption :=  sPaperSize(AcePreview.AcePrinterSetup.PaperSize);
    end;
end;

procedure TAceViewerX.Print;
begin
  PrintbtnClick(Printbtn);
end;

function TAceViewerX.GetLoadPercent: Single;
begin
  result := 0;
  if AcePreview.Filer.AceFile <> nil then
    result := TAceAceFile(AcePreview.Filer.AceFile).PercentDone;
end;

function TAceViewerX.PersistPropertyBagGetClassID(
  out classID: TCLSID): HResult;
begin
  try
  classID := CLASS_AceViewerX;
  Result := S_OK;
  except
  Result := S_FALSE;
  end;
end;

function TAceViewerX.PersistPropertyBagInitNew: HResult;
begin
  Result := S_OK;
end;

function TAceViewerX.PersistPropertyBagLoad(const pPropBag: IPropertyBag;
  const pErrorLog: IErrorLog): HResult;
var  v:olevariant;
  PropName: WideString;
  pwc: PWideChar;
begin
  PropName := 'SRC';
  Result := pPropBag.Read(PWideChar(PropName), v, pErrorLog);
  if Result=S_OK then
    begin
    setLength(FSrc,MAX_PATH);
    If Succeeded(URLDownloadToCacheFile(IUnknown(VCLComObject),PChar(VarToStr(v)),
        PChar(FSrc),MAX_PATH-1,0,nil)) then
      try
      SaveFileDialog.FileName := ExtractFileName(FSrc);
      pwc := StringToWideChar(FSrc,AllocMem(Length(FSrc)*2+1),Length(FSrc)*2);
      try
      LoadFile(WideString(pwc));
      finally
      FreeMem(pwc);
      end;
      except
        On E: Exception do
          MessageBox(GetParent(Handle),PChar(E.Message),'Error',MB_OK+MB_ICONERROR)
      end
    else
      begin
      MessageBox(GetParent(Handle),PChar('Download file error on '+VarToStr(v)+'!'),'Error',MB_OK+MB_ICONERROR);
      FSrc := '';
      end;
    end;
end;

function TAceViewerX.PersistPropertyBagSave(const pPropBag: IPropertyBag;
  fClearDirty, fSaveAllProperties: BOOL): HResult;
begin
  If SaveReport.Enabled then
    SaveReport.Click;
  Result := S_OK
end;

procedure TAceViewerX.SetGenerating(Value: Boolean);
begin
  if FGenerating <> Value then
  begin
    FGenerating := Value;
  end;
  stop.Enabled := FGenerating;

  if Value then Include(FViewerMode, vmGenerating)
  else Exclude(FViewerMode, vmGenerating);

  ToolBar.Enabled := Not (vmPrinting in FViewerMode);
end;

procedure TAceViewerX.UpdatePage;
begin
  If AcePreview.PageCount>0 then
    begin
    SB.Max := AcePreview.PageCount;
    //SB.Hint := 'Page:'+IntToStr(AcePreview.page)+'/'+IntToStr(AcePreview.PageCount)
    SB.Hint := 'Page'#13+ IntToStr(AcePreview.page)+#13'of'#13+IntToStr(AcePreview.PageCount);
    end;
  if ShowFirst then
  begin
    if (AcePreview.PageCount > 1) then
    begin
      ShowFirst := False;
      AcePreview.Invalidate;
    end;
  end;
  if GetLoadPercent>0 then
     begin
     ZoomFit.Enabled := True;
     ZoomToWidth.Enabled := True;
     ZoomToHeight.Enabled := True;
     Zoomin.Enabled := True;
     Zoomout.Enabled := True;
     end
  else
     begin
     ZoomFit.Enabled := false;
     ZoomToWidth.Enabled := false;
     ZoomToHeight.Enabled := false;
     Zoomin.Enabled := false;
     Zoomout.Enabled := false;
     end;

  if GetLoadPercent >= 100 then
     begin
     Generating := False;
     SaveReport.Enabled := True;
     PrintBtn.Enabled := PrintSetup.Enabled;
     end
  else
     begin
     SaveReport.Enabled := false;
     PrintBtn.Enabled := false;
     end;
  SB.Visible := Assigned(AcePreview.Filer.Acefile);
end;

procedure TAceViewerX.ActiveFormCreate(Sender: TObject);
begin
  FSrc := '';
  If printer.Printers.Count>0 then
    begin
    printers.printer.printerindex := -1;
    AcePreview.AcePrinterSetup.GetData;
    PrintSetup.Enabled := true;
    end
  else
    begin
    PrintSetup.Enabled := False;
    PrintBtn.Enabled := False;
    end;
  UpdatePage;
end;

procedure TAceViewerX.ExitButtonClick(Sender: TObject);
begin
  pageSize.Caption := '';
  AcePreview.AceZoom := az10;
  AcePreview.Filer.Acefile.free;
  AcePreview.Filer.Acefile := nil;
  AcePreview.Invalidate;
  FSrc := '';
  UpdatePage;
end;

procedure TAceViewerX.LoadReportClick(Sender: TObject);
var pwc: PWideChar;
begin
  if OpenFileDialog.Execute then
    begin
    AcePreview.Filer.AceFile := nil;
    AcePreview.AceZoom := az100;
    pwc := StringToWideChar(OpenFileDialog.FileName,AllocMem(Length(OpenFileDialog.FileName)*2+1),Length(OpenFileDialog.FileName)*2);
    try
    LoadFile(WideString(pwc));
    finally
    FreeMem(pwc);
    end;
    end;
end;

procedure TAceViewerX.PrintbtnClick(Sender: TObject);
var
  pd: TAcePrintDestination;
  ps: TAcePreviewStatus;
  CopyPS: TAcePrinterSetup;
begin
  CopyPS := TAcePrinterSetup.Create;
  CopyPS.Assign(AcePreview.AcePrinterSetup);

  pd := TAcePrintDestination.Create(Application);
  pd.Viewer := nil;
  pd.Preview := AcePreview;
  pd.AcePrinterSetup := AcePreview.AcePrinterSetup;
  pd.AcePrinterSetup.SetData;

  try
    if (pd.ShowModal = mrOk) then
    begin
      Include(FViewerMode, vmPrinting);
      ToolBar.Enabled := Not (vmPrinting in FViewerMode);
      ps := TAcePreviewStatus.Create(Self);
      try
        ps.Preview := AcePreview;
        ps.Show;
        AcePreview.IgnorePrinterSettings := Not CopyPS.IsEqual(pd.AcePrinterSetup);
        AcePreview.PrintStatus := ps.UpdateStatus;
        AcePreview.SendPagesToPrinter(pd.StartPage, pd.EndPage);
      finally
        ps.free;
      end;
    end;
  finally
    pd.free;
    CopyPS.Free;
    Exclude(FViewerMode, vmPrinting);
    ToolBar.Enabled := Not (vmPrinting in FViewerMode);
  end;
end;

procedure TAceViewerX.PrintSetupClick(Sender: TObject);
begin
  AcePreview.AcePrinterSetup.SetData;
  printersetup.execute;
  AcePreview.AcePrinterSetup.GetData;
end;

procedure TAceViewerX.SaveReportClick(Sender: TObject);
var
   MStream: TMemoryStream;
   FileStream: TFileStream;
   CompressionStream: TCompressionStream;
begin
  SaveFileDialog.FileName := ChangeFileExt(ExtractFileName(FSrc),'');

  if SaveFileDialog.Execute then
    begin
    If LowerCase(ExtractFileExt(SaveFileDialog.FileName))='.acz' then
      try
      MStream := TMemoryStream.Create;
      FileStream := TFileStream.Create(SaveFileDialog.FileName,fmCreate or fmShareDenyWrite);
      FileStream.Position := 0;
      CompressionStream := TCompressionStream.Create(clDefault,FileStream);
      AcePreview.SaveToStream(MStream);
      MStream.Position := 0;
      CompressionStream.CopyFrom(MStream,0);
      finally
      CompressionStream.Free;
      FileStream.Free;
      MStream.Free;
      end
    else
      AcePreview.SaveToFile(SaveFileDialog.FileName);
    end;
end;

procedure TAceViewerX.SBChange(Sender: TObject);
begin
  AcePreview.Page := SB.Position;
  UpdatePage;
end;

procedure TAceViewerX.StopClick(Sender: TObject);
begin
  Generating := False;
end;

procedure TAceViewerX.ZoomClick(Sender: TObject);
var entzoom: integer;
begin
  entZoom := AcePreview.Zoom;
  AcePreview.AceZoom := az100;
  AcePreview.Zoom := entZoom+TComponent(Sender).Tag;
  Zoomin.Hint :='Resize to '+IntToStr(AcePreview.Zoom+Zoomin.Tag)+'%';
  ZoomOut.Hint := 'Shrink to '+IntToStr(AcePreview.Zoom+ZoomOut.Tag)+'%';
  ZoomFit.Down := False;
  ZoomToWidth.Down := False;
  ZoomToHeight.Down := False;
  Zoom100.Down := False;
end;

procedure TAceViewerX.ZoomFitClick(Sender: TObject);
begin
  AcePreview.AceZoom :=TAceZoom(TComponent(Sender).Tag);
  Zoomin.Hint :='Resize to '+IntToStr(AcePreview.Zoom+Zoomin.Tag)+'%';
  ZoomOut.Hint := 'Shrink to '+IntToStr(AcePreview.Zoom+ZoomOut.Tag)+'%';
end;

function TAceViewerX.sPaperSize(PaperSize: Integer): String;
begin
  Case PaperSize of
    DMPAPER_LETTER      : Result := 'Letter 8 12 x 11 in';
    DMPAPER_LETTERSMALL : Result := 'Letter Small 8 12 x 11 in';
    DMPAPER_TABLOID     : Result := 'Tabloid 11 x 17 in';
    DMPAPER_LEDGER      : Result := 'Ledger 17 x 11 in';
    DMPAPER_LEGAL       : Result := 'Legal 8 12 x 14 in';
    DMPAPER_STATEMENT   : Result := 'Statement 5 12 x 8 12 in';
    DMPAPER_EXECUTIVE   : Result := 'Executive 7 14 x 10 12 in';
    DMPAPER_A3      : Result := 'A3 297 x 420 mm';
    DMPAPER_A4      : Result := 'A4 210 x 297 mm';
    DMPAPER_A4SMALL : Result := 'A4 Small 210 x 297 mm';
    DMPAPER_A5      : Result := 'A5 148 x 210 mm';
    DMPAPER_B4      : Result := 'B4 (JIS) 250 x 354';
    DMPAPER_B5      : Result := 'B5 (JIS) 182 x 257 mm';
    DMPAPER_FOLIO   : Result := 'Folio 8 12 x 13 in';
    DMPAPER_QUARTO  : Result := 'Quarto 215 x 275 mm';
    DMPAPER_10X14   : Result := '10x14 in';
    DMPAPER_11X17   : Result := '11x17 in';
    DMPAPER_NOTE    : Result := 'Note 8 12 x 11 in';
    DMPAPER_ENV_9   : Result := 'Envelope #9 3 78 x 8 78';
    DMPAPER_ENV_10  : Result := 'Envelope #10 4 18 x 9 12';
    DMPAPER_ENV_11  : Result := 'Envelope #11 4 12 x 10 38';
    DMPAPER_ENV_12  : Result := 'Envelope #12 4 \276 x 11';
    DMPAPER_ENV_14  : Result := 'Envelope #14 5 x 11 12';
    DMPAPER_CSHEET  : Result := 'C size sheet';
    DMPAPER_DSHEET  : Result := 'D size sheet';
    DMPAPER_ESHEET  : Result := 'E size sheet';
    DMPAPER_ENV_DL  : Result := 'Envelope DL 110 x 220mm';
    DMPAPER_ENV_C5  : Result := 'Envelope C5 162 x 229 mm';
    DMPAPER_ENV_C3  : Result := 'Envelope C3  324 x 458 mm';
    DMPAPER_ENV_C4  : Result := 'Envelope C4  229 x 324 mm';
    DMPAPER_ENV_C6  : Result := 'Envelope C6  114 x 162 mm';
    DMPAPER_ENV_C65  : Result := 'Envelope C65 114 x 229 mm';
    DMPAPER_ENV_B4   : Result := 'Envelope B4  250 x 353 mm';
    DMPAPER_ENV_B5   : Result := 'Envelope B5  176 x 250 mm';
    DMPAPER_ENV_B6   : Result := 'Envelope B6  176 x 125 mm';
    DMPAPER_ENV_ITALY          : Result := 'Envelope 110 x 230 mm';
    DMPAPER_ENV_MONARCH        : Result := 'Envelope Monarch 3.875 x 7.5 in';
    DMPAPER_ENV_PERSONAL       : Result := '6 34 Envelope 3 58 x 6 12 in';
    DMPAPER_FANFOLD_US         : Result := 'US Std Fanfold 14 78 x 11 in';
    DMPAPER_FANFOLD_STD_GERMAN : Result := 'German Std Fanfold 8 12 x 12 in';
    DMPAPER_FANFOLD_LGL_GERMAN : Result := 'German Legal Fanfold 8 12 x 13 in';
    DMPAPER_ISO_B4             : Result := 'B4 (ISO) 250 x 353 mm';
    DMPAPER_JAPANESE_POSTCARD  : Result := 'Japanese Postcard 100 x 148 mm';
    DMPAPER_9X11               : Result := '9 x 11 in';
    DMPAPER_10X11              : Result := '10 x 11 in';
    DMPAPER_15X11              : Result := '15 x 11 in';
    DMPAPER_ENV_INVITE         : Result := 'Envelope Invite 220 x 220 mm';
    DMPAPER_RESERVED_48        : Result := 'RESERVED--DO NOT USE';
    DMPAPER_RESERVED_49        : Result := 'RESERVED--DO NOT USE';
    DMPAPER_LETTER_EXTRA       : Result := 'Letter Extra 9 \275 x 12 in';
    DMPAPER_LEGAL_EXTRA        : Result := 'Legal Extra 9 \275 x 15 in';
    DMPAPER_TABLOID_EXTRA      : Result := 'Tabloid Extra 11.69 x 18 in';
    DMPAPER_A4_EXTRA           : Result := 'A4 Extra 9.27 x 12.69 in';
    DMPAPER_LETTER_TRANSVERSE  : Result := 'Letter Transverse 8 \275 x 11 in';
    DMPAPER_A4_TRANSVERSE      : Result := 'A4 Transverse 210 x 297 mm';
    DMPAPER_LETTER_EXTRA_TRANSVERSE : Result := 'Letter Extra Transverse 9\275 x 12 in';
    DMPAPER_A_PLUS        : Result := 'SuperASuperAA4 227 x 356 mm';
    DMPAPER_B_PLUS        : Result := 'SuperBSuperBA3 305 x 487 mm';
    DMPAPER_LETTER_PLUS   : Result := 'Letter Plus 8.5 x 12.69 in';
    DMPAPER_A4_PLUS       : Result := 'A4 Plus 210 x 330 mm';
    DMPAPER_A5_TRANSVERSE : Result := 'A5 Transverse 148 x 210 mm';
    DMPAPER_B5_TRANSVERSE : Result := 'B5 (JIS) Transverse 182 x 257 mm';
    DMPAPER_A3_EXTRA      : Result := 'A3 Extra 322 x 445 mm';
    DMPAPER_A5_EXTRA      : Result := 'A5 Extra 174 x 235 mm';
    DMPAPER_B5_EXTRA      : Result := 'B5 (ISO) Extra 201 x 276 mm';
    DMPAPER_A2            : Result := 'A2 420 x 594 mm';
    DMPAPER_A3_TRANSVERSE : Result := 'A3 Transverse 297 x 420 mm';
    DMPAPER_A3_EXTRA_TRANSVERSE : Result := 'A3 Extra Transverse 322 x 445 mm';
    DMPAPER_DBL_JAPANESE_POSTCARD : Result := 'Japanese Double Postcard 200 x 148 mm';
    DMPAPER_A6                  : Result := 'A6 105 x 148 mm';
    DMPAPER_JENV_KAKU2          : Result := 'Japanese Envelope Kaku #2';
    DMPAPER_JENV_KAKU3          : Result := 'Japanese Envelope Kaku #3';
    DMPAPER_JENV_CHOU3          : Result := 'Japanese Envelope Chou #3';
    DMPAPER_JENV_CHOU4          : Result := 'Japanese Envelope Chou #4';
    DMPAPER_LETTER_ROTATED      : Result := 'Letter Rotated 11 x 8 1/2 11 in';
    DMPAPER_A3_ROTATED          : Result := 'A3 Rotated 420 x 297 mm';
    DMPAPER_A4_ROTATED          : Result := 'A4 Rotated 297 x 210 mm';
    DMPAPER_A5_ROTATED          : Result := 'A5 Rotated 210 x 148 mm';
    DMPAPER_B4_JIS_ROTATED      : Result := 'B4 (JIS) Rotated 364 x 257 mm';
    DMPAPER_B5_JIS_ROTATED      : Result := 'B5 (JIS) Rotated 257 x 182 mm';
    DMPAPER_JAPANESE_POSTCARD_ROTATED : Result := 'Japanese Postcard Rotated 148 x 100 mm';
    DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED : Result := 'Double Japanese Postcard Rotated 148 x 200 mm';
    DMPAPER_A6_ROTATED          : Result := 'A6 Rotated 148 x 105 mm';
    DMPAPER_JENV_KAKU2_ROTATED  : Result := 'Japanese Envelope Kaku #2 Rotated';
    DMPAPER_JENV_KAKU3_ROTATED  : Result := 'Japanese Envelope Kaku #3 Rotated';
    DMPAPER_JENV_CHOU3_ROTATED  : Result := 'Japanese Envelope Chou #3 Rotated';
    DMPAPER_JENV_CHOU4_ROTATED  : Result := 'Japanese Envelope Chou #4 Rotated';
    DMPAPER_B6_JIS              : Result := 'B6 (JIS) 128 x 182 mm';
    DMPAPER_B6_JIS_ROTATED      : Result := 'B6 (JIS) Rotated 182 x 128 mm';
    DMPAPER_12X11               : Result := '12 x 11 in';
    DMPAPER_JENV_YOU4           : Result := 'Japanese Envelope You #4';
    DMPAPER_JENV_YOU4_ROTATED   : Result := 'Japanese Envelope You #4 Rotated';
    DMPAPER_P16K                : Result := 'PRC 16K 146 x 215 mm';
    DMPAPER_P32K                : Result := 'PRC 32K 97 x 151 mm';
    DMPAPER_P32KBIG             : Result := 'PRC 32K(Big) 97 x 151 mm';
    DMPAPER_PENV_1              : Result := 'PRC Envelope #1 102 x 165 mm';
    DMPAPER_PENV_2              : Result := 'PRC Envelope #2 102 x 176 mm';
    DMPAPER_PENV_3              : Result := 'PRC Envelope #3 125 x 176 mm';
    DMPAPER_PENV_4              : Result := 'PRC Envelope #4 110 x 208 mm';
    DMPAPER_PENV_5              : Result := 'PRC Envelope #5 110 x 220 mm';
    DMPAPER_PENV_6              : Result := 'PRC Envelope #6 120 x 230 mm';
    DMPAPER_PENV_7              : Result := 'PRC Envelope #7 160 x 230 mm';
    DMPAPER_PENV_8              : Result := 'PRC Envelope #8 120 x 309 mm';
    DMPAPER_PENV_9              : Result := 'PRC Envelope #9 229 x 324 mm';
    DMPAPER_PENV_10             : Result := 'PRC Envelope #10 324 x 458 mm';
    DMPAPER_P16K_ROTATED        : Result := 'PRC 16K Rotated';
    DMPAPER_P32K_ROTATED        : Result := 'PRC 32K Rotated';
    DMPAPER_P32KBIG_ROTATED     : Result := 'PRC 32K(Big) Rotated';
    DMPAPER_PENV_1_ROTATED      : Result := 'PRC Envelope #1 Rotated 165 x 102 mm';
    DMPAPER_PENV_2_ROTATED      : Result := 'PRC Envelope #2 Rotated 176 x 102 mm';
    DMPAPER_PENV_3_ROTATED      : Result := 'PRC Envelope #3 Rotated 176 x 125 mm';
    DMPAPER_PENV_4_ROTATED      : Result := 'PRC Envelope #4 Rotated 208 x 110 mm';
    DMPAPER_PENV_5_ROTATED      : Result := 'PRC Envelope #5 Rotated 220 x 110 mm';
    DMPAPER_PENV_6_ROTATED      : Result := 'PRC Envelope #6 Rotated 230 x 120 mm';
    DMPAPER_PENV_7_ROTATED      : Result := 'PRC Envelope #7 Rotated 230 x 160 mm';
    DMPAPER_PENV_8_ROTATED      : Result := 'PRC Envelope #8 Rotated 309 x 120 mm';
    DMPAPER_PENV_9_ROTATED      : Result := 'PRC Envelope #9 Rotated 324 x 229 mm';
    DMPAPER_PENV_10_ROTATED     : Result := 'PRC Envelope #10 Rotated 458 x 324 mm';
    DMPAPER_USER                : Result := 'customized';
  else
    Result := 'Unknown';
  end;
  If (Result<>'Unknown')then
    begin
    If AcePreview.AcePrinterSetup.Orientation=DMORIENT_PORTRAIT then
      Result := Result+' - portrait'
    else  If AcePreview.AcePrinterSetup.Orientation=DMORIENT_LANDSCAPE then
      Result := Result+' - landscape'
    end;
end;

initialization
  TActiveFormFactory.Create(
    ComServer,
    TActiveFormControl,
    TAceViewerX,
    Class_AceViewerX,
    1,
    '',
    OLEMISC_SIMPLEFRAME or OLEMISC_ACTSLIKELABEL,
    tmApartment);
end.
