library AceViewer;

uses
  ComServ,registry,ComObj,
  AceViewer_TLB in 'AceViewer_TLB.pas',
  AceViewerImpl in 'AceViewerImpl.pas' {AceViewerX: TActiveForm} {AceViewerX: CoClass};

{$E ocx}

function DllRegisterServer: HResult; stdcall;
var bdata: array[0..3] of Byte;
  IEPath: String;
begin
  Result := ComServ.DLLRegisterServer;
  if (Result and $80000000 = 0) then //Succeeded()
    With TRegistry.Create do
     try
     RootKey := $80000002; //HKEY_LOCAL_MACHINE
     OpenKey('\SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\IEXPLORE.EXE',False);
     IEPath := ReadString('');
     CloseKey;

     RootKey := $80000000;//HKEY_CLASSES_ROOT
     OpenKey('\MIME\Database\Content Type\application/x-ace',true);
     WriteString('CLSID',GUIDToString(CLASS_AceViewerX));
     WriteString('Extension','.ace');
     CloseKey;
     OpenKey('\.ace',true);
     WriteString('','AceViewer.AceViewerX');
     WriteString('Content Type','application/x-ace');
     CloseKey;
     OpenKey('\CLSID\'+GUIDToString(CLASS_AceViewerX)+'\EnableFullPage\.ace',true);
     CloseKey;
     OpenKey('\MIME\Database\Content Type\application/x-acz',true);
     WriteString('CLSID',GUIDToString(CLASS_AceViewerX));
     WriteString('Extension','.acz');
     CloseKey;
     OpenKey('\.acz',true);
     WriteString('','AceViewer.AceViewerX');
     WriteString('Content Type','application/x-acz');
     CloseKey;
     OpenKey('\CLSID\'+GUIDToString(CLASS_AceViewerX)+'\EnableFullPage\.acz',true);
     CloseKey;

     OpenKey('\AceViewer.AceViewerX',true);
     WriteString('','Ace Report');
     FillChar(bdata,4,0);
     bdata[2] := 1;
     WriteBinaryData('EditFlags',bdata,4);
     CloseKey;

     OpenKey('\AceViewer.AceViewerX\Clsid',true);
     WriteString('Clsid',GUIDToString(CLASS_AceViewerX));
     CloseKey;
     OpenKey('\AceViewer.AceViewerX\DefaultIcon',True);
     WriteString('','"'+IEPath+'",20');
     CloseKey;
     OpenKey('\AceViewer.AceViewerX\Shell\open\command',true);
     WriteString('','"'+IEPath+'" -nohome');
     CloseKey;
     OpenKey('\AceViewer.AceViewerX\Shell\open\ddeexec',true);
     WriteString('','"file://%1",,-1,,,,,');
     CloseKey;
     OpenKey('\AceViewer.AceViewerX\Shell\open\ddeexec\Application',True);
     WriteString('','IExplore');
     CloseKey;
     OpenKey('\AceViewer.AceViewerX\Shell\open\ddeexec\Topic',True);
     WriteString('','WWW_OpenURL');
     CloseKey;
     finally
     Free;
     end;
end;

function DllUnregisterServer: HResult; stdcall;
begin
  Result := ComServ.DllUnregisterServer;
  if (Result and $80000000 = 0) then //Succeeded()
    With TRegistry.Create do
     try
     RootKey := $80000000;//HKEY_CLASSES_ROOT
     DeleteKey('\MIME\Database\Content Type\application/x-ace');
     DeleteKey('\.ace');
     DeleteKey('\CLSID\'+GUIDToString(CLASS_AceViewerX)+'\EnableFullPage\.ace');

     DeleteKey('\MIME\Database\Content Type\application/x-acz');
     DeleteKey('\.acz');
     DeleteKey('\CLSID\'+GUIDToString(CLASS_AceViewerX)+'\EnableFullPage\.acz');

     DeleteKey('\AceViewer.AceViewerX');
     CloseKey;
     finally
     free;
     end;
end;

exports
  DllGetClassObject,
  DllCanUnloadNow,
  DllRegisterServer,
  DllUnregisterServer;

{$R *.TLB}

{$R *.RES}

begin
end.
