unit aceweb;

interface

uses
  SysUtils, Classes, HTTPApp,zlib;

type
  TWebModule1 = class(TWebModule)
    procedure WebModule1AcePackAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    function ModuleFileName: String;
    function currpath: String;
    function FetchParam(Request: TWebRequest;FieldName: String): String;
    function CompressAce(AceFileName:PChar): Boolean;
    function CompressFile(FileName,CompressTo: String;CL:TCompressionLevel=clDefault): Boolean;
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

uses windows;
{$R *.DFM}
type
  TClearDir=class(TThread)
  private
    FFolder: String;
    function getFileDateTime(FileName: string): TDateTime;
  protected
    procedure Execute;override;
  public
    constructor Create(FolderName: String);
  end;

function TWebModule1.CompressAce(AceFileName: PChar): Boolean;
var FP,FN: String;
begin
  FN := StrPas(AceFileName);
  FP := ExtractFilePath(FN);
  If FP='' then
    begin
    FP := ExtractFilePath(ModuleFileName);
    If FileExists(FN) then
      FN := FP+FN
    else IF FileExists(FP+'AceMeta\'+FN) then
      FN := FP+'AceMeta\'+FN
    else
      FN := '';
    end
  else If not FileExists(FN) then FN := '';
  If FN='' then
    Result := False
  else
    try
    Result := CompressFile(FN,ChangeFileExt(FN,'.acz'));
    if FileExists(FN) then SysUtils.DeleteFile(FN);
    except
      Result := False;
    end
end;

function TWebModule1.CompressFile(FileName, CompressTo: String;
  CL: TCompressionLevel): Boolean;
var      FileStream: TStream;
     CompFileStream: TStream;
  CompressionStream: TCompressionStream;
begin
  If FileExists(CompressTo) and not SysUtils.DeleteFile(CompressTo) then
    begin
    result := False;
    exit;
    end;
  if FileExists(FileName) then
    try
    FileStream := TFileStream.Create(FileName,fmOpenRead OR fmShareDenyWrite);
    CompFileStream := TFileStream.Create(CompressTo,fmCreate);
    CompFileStream.Position :=0;
    CompressionStream := TCompressionStream.Create(CL,CompFileStream);
    CompressionStream.CopyFrom(FileStream,0);
    finally
    CompressionStream.Free;
    CompFileStream.Free;
    FileStream.Free;
    Result := True;
    end
  else Result := False;
end;

function TWebModule1.currpath: String;
begin
  Result := ExtractFilePath(ModuleFileName);
end;

function TWebModule1.FetchParam(Request: TWebRequest;FieldName: String): String;
begin
 If Assigned(Request) then
  Case Request.MethodType of
   mtGet: Result := Request.QueryFields.Values[FieldName];
   mtPost: Result := Request.ContentFields.Values[FieldName];
   mtHead: Result := Request.GetFieldByName(FieldName);
  else
   Result := '';
  end;
end;


function TWebModule1.ModuleFileName: String;
var FileName : array[0..MAX_PATH] of char;
begin
  FillChar(FileName, sizeof(FileName), 0);
  GetModuleFileName(hInstance, FileName, sizeof(FileName));
  Result := FileName;
end;

procedure TWebModule1.WebModule1AcePackAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var CB,FN,RN: String;
  function getFN(FileName: String): String;
  var FP: String;
  begin
  FP := ExtractFilePath(FileName);
  If FP='' then
    begin
    FP := currpath+'AceMeta\';
    If not FileExists(FileName) and FileExists(FP+FileName) then
      Result := FP+FileName
    else If not FileExists(FN) then
      Result := '';
    end
  else
    begin
    If FileExists(FileName) then Result := FileName
    else Result := '';
    end;
  If (Result<>'') and (ExtractFilePath(FileName)<>'')and (ExtractFilePath(Result)<>FP) then
    CopyFile(PChar(Result),PChar(FP+ExtractFileName(Result)),false);
  end;
begin
  FN := '';
  FN := FetchParam(Request,'ace');
  If FN='' then
    begin
    Response.SendRedirect(Request.ScriptName+'/help');
    exit;
    end;
  CB := FetchParam(Request,'codebase');
  If (CB<>'') and (CB[Length(CB)]<>'/') then CB := CB+'/';
  CB := CB+'aceviewer.cab#version=1,0,0,0';
  FN := getFN(FN);
  If (FN='') then
    FN := getFN(ChangeFileExt(FetchParam(Request,'ace'),'.acz'));
  If LowerCase(ExtractFileExt(FN))='.ace' then
    begin
    RN :='AceMeta/'+ExtractFileName(ChangeFileExt(FN,'.acz'));
    If not CompressAce(PChar(FN)) then
      FN := ''
    else
      begin
      If (Pos('acemeta/',LowerCase(FN))=0) and
         CopyFile(PChar(FN),PChar(ExtractFilePath(ModuleFileName)+'AceMeta\'+ExtractFileName(FN)),False) then
        SysUtils.Deletefile(FN);
      end;
    end
  else
    RN :='AceMeta/'+ExtractFileName(FN);
  If FN='' then
     Response.Content := '<html>'+
     '<meta http-equiv="Expires" content="-1"><meta http-equiv="pragma" content="no-cache">'+
     '<style>body {margin: 0px 0px;padding:0px 0px;}</style>'+
     '<body><span name="MsgArea" style="position: absolute;'+
            'position:relative;top:0;left:0;width:expression(offsetParent.clientWidth);'+
            'height:expression(offsetParent.clientHeight);'+
     'FileG'+FetchParam(Request,'ace')+' not existsI</body></html>'
  else
  try
  //Clear currpath/Acemeta's Files
  TClearDir.Create(currpath+'AceMeta');
  Response.Content :='<html><meta http-equiv="Expires" content="-1">'+
       '<meta http-equiv="pragma" content="no-cache">'+
       '<style>body {margin: 0px 0px;padding:0px 0px;}</style>'+
       '<body><object type="application/x-acz" style="position:relative;top:0;left:0;'+
       'width:expression(offsetParent.clientWidth);height:expression(offsetParent.clientHeight)" '+
       'classid="clsid:20456721-26be-11d5-97a8-0050bada21ba" codebase="'+CB+'">'+
       '<param name="src" value="'+RN+'"></object></body></html>';
  except
    on E: Exception do
    Response.Content := '<html>'+
        '<meta http-equiv="Expires" content="-1"><meta http-equiv="pragma" content="no-cache">'+
        '<style>body {margin: 0px 0px;padding:0px 0px;}</style>'+
        '<body><span name="MsgArea" style="position: absolute;'+
               'position:relative;top:0;left:0;width:expression(offsetParent.clientWidth);'+
               'height:expression(offsetParent.clientHeight);'+
        'Compress error on fileG'+FN+'I<br>Error message:G<br><pre>'+E.Message+
        '</pre></span></body></html>';
  end;
end;

{ TClearDir }

constructor TClearDir.Create(FolderName: String);
begin
  FreeOnTerminate := true;
  If FileGetAttr(FolderName)<>16 then
    FFolder := ''
  else
    begin
    If FolderName[Length(FolderName)]='\' then
      FFolder := FolderName
    else
      FFolder := FolderName+'\';
    end;
  inherited Create(False);
end;

procedure TClearDir.Execute;
var FileList: TStringList;
  SerchRec:TSearchRec;
begin
  If FFolder<>'' then
    With TStringList.Create do
      try
      If FindFirst(FFolder+'*.*?',faAnyFile,SerchRec)=0 then
        begin
        repeat
          If (ExtractFileName(SerchRec.Name)<>'.') and
             (ExtractFileName(SerchRec.Name)<>'..') then
          Add(SerchRec.Name);
        until FindNext(SerchRec)<>0;
        SysUtils.FindClose(SerchRec);
        end;
      While Count>0  do
        begin
        //over 10 minutes
        If FileExists(FFolder+Strings[0]) and (Now-getFileDateTime(FFolder+Strings[0])>1/144) then
          SysUtils.DeleteFile(FFolder+Strings[0]);
        try
        Delete(0);
        except end;
        end;
      finally
      Free;
      end;
end;

function TClearDir.getFileDateTime(FileName: string): TDateTime;
var Age: Longint;
begin
  If FileExists(FileName) then
    try
    Age := FileAge(FileName);
    if Age = -1 then
      Result := 0
    else
      Result := FileDateToDateTime(Age);
    except
    Result := 0;
    end
  else
    Result := 0;
end;

end.
