unit AceViewerImpl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ActiveX, AxCtrls, AceViewer_TLB, StdVcl, Buttons, ComCtrls, ToolWin,
  ImgList, AcePrev, ExtCtrls, AceMeter, StdCtrls,AceFile, AceSetup,urlmon;

type
  TAceViewerMode = set of (vmGenerating, vmPrinting);
  TAceViewerX = class(TActiveForm, IAceViewerX,IPersistPropertyBag)
    ToolBar: TToolBar;
    ZoomFit: TToolButton;
    ZoomToWidth: TToolButton;
    Zoom100: TToolButton;
    Zoomin: TToolButton;
    ZoomOut: TToolButton;
    Separator3: TToolButton;
    SaveReport: TToolButton;
    LoadReport: TToolButton;
    Separator4: TToolButton;
    PrintSetup: TToolButton;
    Printbtn: TToolButton;
    Separator2: TToolButton;
    ExitButton: TSpeedButton;
    LoadMeter: TAceMeter;
    Stop: TSpeedButton;
    AcePreview: TAcePreview;
    SB: TScrollBar;
    OpenFileDialog: TOpenDialog;
    Images: TImageList;
    SaveFileDialog: TSaveDialog;
    PrinterSetup: TPrinterSetupDialog;        
    procedure LoadReportClick(Sender: TObject);
    procedure SaveReportClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure PrintSetupClick(Sender: TObject);
    procedure ZoomFitClick(Sender: TObject);
    procedure ZoomClick(Sender: TObject);
    procedure ActiveFormCreate(Sender: TObject);
    procedure PrintbtnClick(Sender: TObject);
    procedure StopClick(Sender: TObject);
    procedure SBChange(Sender: TObject);
  private
    { Private declarations }
    FEvents: IAceViewerXEvents;
    ShowFirst: Boolean;
    FOnAbort: TNotifyEvent;
    FGenerating: Boolean;
    FAceZoom: Boolean;
    FViewerMode: TAceViewerMode;
    FSrc: String;
    procedure SetGenerating( Value: Boolean);
    procedure ActivateEvent(Sender: TObject);
    procedure ClickEvent(Sender: TObject);
    procedure CreateEvent(Sender: TObject);
    procedure DblClickEvent(Sender: TObject);
    procedure DeactivateEvent(Sender: TObject);
    procedure DestroyEvent(Sender: TObject);
    procedure KeyPressEvent(Sender: TObject; var Key: Char);
    procedure PaintEvent(Sender: TObject);
  protected
    {implement IPersistPropertyBag}
    function IPersistPropertyBag.GetClassID =PersistPropertyBagGetClassID;
    function IPersistPropertyBag.InitNew = PersistPropertyBagInitNew;
    function IPersistPropertyBag.Load = PersistPropertyBagLoad;
    function IPersistPropertyBag.Save = PersistPropertyBagSave;
    function PersistPropertyBagInitNew: HResult; stdcall;
    function PersistPropertyBagGetClassID(out classID: TCLSID): HResult;stdcall;
    function PersistPropertyBagLoad(const pPropBag: IPropertyBag; const pErrorLog: IErrorLog): HResult; stdcall;
    function PersistPropertyBagSave(const pPropBag: IPropertyBag;fClearDirty: BOOL; fSaveAllProperties: BOOL): HResult; stdcall;
    { Protected declarations }
    procedure DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage); override;
    procedure EventSinkChanged(const EventSink: IUnknown); override;
    function Get_Active: WordBool; safecall;
    function Get_AutoScroll: WordBool; safecall;
    function Get_AutoSize: WordBool; safecall;
    function Get_AxBorderStyle: TxActiveFormBorderStyle; safecall;
    function Get_Caption: WideString; safecall;
    function Get_Color: OLE_COLOR; safecall;
    function Get_Cursor: Smallint; safecall;
    function Get_DoubleBuffered: WordBool; safecall;
    function Get_DropTarget: WordBool; safecall;
    function Get_Enabled: WordBool; safecall;
    function Get_Font: IFontDisp; safecall;
    function Get_HelpFile: WideString; safecall;
    function Get_KeyPreview: WordBool; safecall;
    function Get_PixelsPerInch: Integer; safecall;
    function Get_PrintScale: TxPrintScale; safecall;
    function Get_Scaled: WordBool; safecall;
    function Get_Visible: WordBool; safecall;
    function Get_VisibleDockClientCount: Integer; safecall;
    procedure _Set_Font(const Value: IFontDisp); safecall;
    procedure Set_AutoScroll(Value: WordBool); safecall;
    procedure Set_AutoSize(Value: WordBool); safecall;
    procedure Set_AxBorderStyle(Value: TxActiveFormBorderStyle); safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    procedure Set_Color(Value: OLE_COLOR); safecall;
    procedure Set_Cursor(Value: Smallint); safecall;
    procedure Set_DoubleBuffered(Value: WordBool); safecall;
    procedure Set_DropTarget(Value: WordBool); safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    procedure Set_Font(var Value: IFontDisp); safecall;
    procedure Set_HelpFile(const Value: WideString); safecall;
    procedure Set_KeyPreview(Value: WordBool); safecall;
    procedure Set_PixelsPerInch(Value: Integer); safecall;
    procedure Set_PrintScale(Value: TxPrintScale); safecall;
    procedure Set_Scaled(Value: WordBool); safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_Src: WideString; safecall;
    procedure LoadFile(const filename: WideString); safecall;
    procedure Print; safecall;
  public
    { Public declarations }
    procedure Initialize; override;
    function GetLoadPercent: Single;
    procedure UpdatePage;
    property Generating: Boolean read FGenerating write SetGenerating;
  end;

implementation

uses ComObj, ComServ,printers, aceout, clipbrd, acedest, acepstat, acegoto,
     aceutil, sctconst;

{$R *.DFM}

{ TAceViewerX }

procedure TAceViewerX.DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage);
begin
  { Define property pages here.  Property pages are defined by calling
    DefinePropertyPage with the class id of the page.  For example,
      DefinePropertyPage(Class_AceViewerXPage); }
end;

procedure TAceViewerX.EventSinkChanged(const EventSink: IUnknown);
begin
  FEvents := EventSink as IAceViewerXEvents;
end;

procedure TAceViewerX.Initialize;
begin
  inherited Initialize;
  OnActivate := ActivateEvent;
  OnClick := ClickEvent;
  OnCreate := CreateEvent;
  OnDblClick := DblClickEvent;
  OnDeactivate := DeactivateEvent;
  OnDestroy := DestroyEvent;
  OnKeyPress := KeyPressEvent;
  OnPaint := PaintEvent;
end;

function TAceViewerX.Get_Active: WordBool;
begin
  Result := Active;
end;

function TAceViewerX.Get_AutoScroll: WordBool;
begin
  Result := AutoScroll;
end;

function TAceViewerX.Get_AutoSize: WordBool;
begin
  Result := AutoSize;
end;

function TAceViewerX.Get_AxBorderStyle: TxActiveFormBorderStyle;
begin
  Result := Ord(AxBorderStyle);
end;

function TAceViewerX.Get_Caption: WideString;
begin
  Result := WideString(Caption);
end;

function TAceViewerX.Get_Color: OLE_COLOR;
begin
  Result := OLE_COLOR(Color);
end;

function TAceViewerX.Get_Cursor: Smallint;
begin
  Result := Smallint(Cursor);
end;

function TAceViewerX.Get_DoubleBuffered: WordBool;
begin
  Result := DoubleBuffered;
end;

function TAceViewerX.Get_DropTarget: WordBool;
begin
  Result := DropTarget;
end;

function TAceViewerX.Get_Enabled: WordBool;
begin
  Result := Enabled;
end;

function TAceViewerX.Get_Font: IFontDisp;
begin
  GetOleFont(Font, Result);
end;

function TAceViewerX.Get_HelpFile: WideString;
begin
  Result := WideString(HelpFile);
end;

function TAceViewerX.Get_KeyPreview: WordBool;
begin
  Result := KeyPreview;
end;

function TAceViewerX.Get_PixelsPerInch: Integer;
begin
  Result := PixelsPerInch;
end;

function TAceViewerX.Get_PrintScale: TxPrintScale;
begin
  Result := Ord(PrintScale);
end;

function TAceViewerX.Get_Scaled: WordBool;
begin
  Result := Scaled;
end;

function TAceViewerX.Get_Visible: WordBool;
begin
  Result := Visible;
end;

function TAceViewerX.Get_VisibleDockClientCount: Integer;
begin
  Result := VisibleDockClientCount;
end;

procedure TAceViewerX._Set_Font(const Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TAceViewerX.ActivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnActivate;
end;

procedure TAceViewerX.ClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnClick;
end;

procedure TAceViewerX.CreateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnCreate;
end;

procedure TAceViewerX.DblClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDblClick;
end;

procedure TAceViewerX.DeactivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDeactivate;
end;

procedure TAceViewerX.DestroyEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDestroy;
end;

procedure TAceViewerX.KeyPressEvent(Sender: TObject; var Key: Char);
var
  TempKey: Smallint;
begin
  TempKey := Smallint(Key);
  if FEvents <> nil then FEvents.OnKeyPress(TempKey);
  Key := Char(TempKey);
end;

procedure TAceViewerX.PaintEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnPaint;
end;

procedure TAceViewerX.Set_AutoScroll(Value: WordBool);
begin
  AutoScroll := Value;
end;

procedure TAceViewerX.Set_AutoSize(Value: WordBool);
begin
  AutoSize := Value;
end;

procedure TAceViewerX.Set_AxBorderStyle(Value: TxActiveFormBorderStyle);
begin
  AxBorderStyle := TActiveFormBorderStyle(Value);
end;

procedure TAceViewerX.Set_Caption(const Value: WideString);
begin
  Caption := TCaption(Value);
end;

procedure TAceViewerX.Set_Color(Value: OLE_COLOR);
begin
  Color := TColor(Value);
end;

procedure TAceViewerX.Set_Cursor(Value: Smallint);
begin
  Cursor := TCursor(Value);
end;

procedure TAceViewerX.Set_DoubleBuffered(Value: WordBool);
begin
  DoubleBuffered := Value;
end;

procedure TAceViewerX.Set_DropTarget(Value: WordBool);
begin
  DropTarget := Value;
end;

procedure TAceViewerX.Set_Enabled(Value: WordBool);
begin
  Enabled := Value;
end;

procedure TAceViewerX.Set_Font(var Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TAceViewerX.Set_HelpFile(const Value: WideString);
begin
  HelpFile := String(Value);
end;

procedure TAceViewerX.Set_KeyPreview(Value: WordBool);
begin
  KeyPreview := Value;
end;

procedure TAceViewerX.Set_PixelsPerInch(Value: Integer);
begin
  PixelsPerInch := Value;
end;

procedure TAceViewerX.Set_PrintScale(Value: TxPrintScale);
begin
  PrintScale := TPrintScale(Value);
end;

procedure TAceViewerX.Set_Scaled(Value: WordBool);
begin
  Scaled := Value;
end;

procedure TAceViewerX.Set_Visible(Value: WordBool);
begin
  Visible := Value;
end;

function TAceViewerX.Get_Src: WideString;
begin
  Result := FSrc;
end;

procedure TAceViewerX.LoadFile(const filename: WideString);
begin
  If FileExists(filename) then
    begin
    FSrc := filename;
    AcePreview.LoadFromFile(filename);
    UpdatePage;
    end;
end;

procedure TAceViewerX.Print;
begin
  PrintbtnClick(Printbtn);
end;

function TAceViewerX.GetLoadPercent: Single;
begin
  result := 0;
  if AcePreview.Filer.AceFile <> nil then
    result := TAceAceFile(AcePreview.Filer.AceFile).PercentDone;
end;

function TAceViewerX.PersistPropertyBagGetClassID(
  out classID: TCLSID): HResult;
begin
  try
  classID := CLASS_AceViewerX;
  Result := S_OK;
  except
  Result := S_FALSE;
  end;
end;

function TAceViewerX.PersistPropertyBagInitNew: HResult;
begin
  Result := S_OK;
end;

function TAceViewerX.PersistPropertyBagLoad(const pPropBag: IPropertyBag;
  const pErrorLog: IErrorLog): HResult;
var  v:olevariant;
  PropName: WideString;
begin
  PropName := 'SRC';
  Result := pPropBag.Read(PWideChar(PropName), v, pErrorLog);
  if Result=S_OK then
    begin
    setLength(FSrc,MAX_PATH);
    If Succeeded(URLDownloadToCacheFile(IUnknown(VCLComObject),PChar(VarToStr(v)),
        PChar(FSrc),MAX_PATH-1,0,nil)) then
      LoadFile(FSrc)
    else
      begin
      ShowMessage('File:'+VarToStr(v)+'download failed!');
      FSrc := '';
      end;
    end;
end;

function TAceViewerX.PersistPropertyBagSave(const pPropBag: IPropertyBag;
  fClearDirty, fSaveAllProperties: BOOL): HResult;
begin
  Result := S_OK
end;

procedure TAceViewerX.SetGenerating(Value: Boolean);
begin
  if FGenerating <> Value then
  begin
    FGenerating := Value;
  end;
  stop.Enabled := FGenerating;

  if Value then Include(FViewerMode, vmGenerating)
  else Exclude(FViewerMode, vmGenerating);

  ToolBar.Enabled := Not (vmPrinting in FViewerMode);
end;

procedure TAceViewerX.UpdatePage;
begin
  LoadMeter.Progress := Round(GetLoadPercent);
  If AcePreview.PageCount>0 then
    begin
    SB.Max := AcePreview.PageCount;
    SB.Hint := 'Page:'+IntToStr(AcePreview.page)+'/'+IntToStr(AcePreview.PageCount)
//    SB.Hint := ''#13''#13+ IntToStr(AcePreview.PageCount) + #13''#13+ IntToStr(AcePreview.page);
    end;
  if ShowFirst then
  begin
    if (AcePreview.PageCount > 1) Or (LoadMeter.Progress = 100) then
    begin
      ShowFirst := False;
      AcePreview.Invalidate;
    end;
  end;
  if LoadMeter.Progress>0 then
     begin
     ZoomFit.Enabled := True;
     ZoomToWidth.Enabled := True;
     Zoom100.Enabled := True;
     Zoomin.Enabled := True;
     Zoomout.Enabled := True;
     end
  else
     begin
     ZoomFit.Enabled := false;
     ZoomToWidth.Enabled := false;
     Zoom100.Enabled := false;
     Zoomin.Enabled := false;
     Zoomout.Enabled := false;
     end;

  if LoadMeter.Progress = 100 then
     begin
     Generating := False;
     SaveReport.Enabled := True;
     PrintBtn.Enabled := PrintSetup.Enabled;
     end
  else
     begin
     SaveReport.Enabled := false;
     PrintBtn.Enabled := false;
     end;
  SB.Visible := Assigned(AcePreview.Filer.Acefile);
end;

procedure TAceViewerX.ActiveFormCreate(Sender: TObject);
begin                 
  FSrc := '';
  If printer.Printers.Count>0 then
    begin
    printers.printer.printerindex := -1;
    AcePreview.AcePrinterSetup.GetData;
    PrintSetup.Enabled := true;
    end
  else
    begin
    PrintSetup.Enabled := False;
    PrintBtn.Enabled := False;
    end;
  UpdatePage;
end;

procedure TAceViewerX.ExitButtonClick(Sender: TObject);
begin
  AcePreview.AceZoom := az10;
  AcePreview.Filer.Acefile.free;
  AcePreview.Filer.Acefile := nil;
  AcePreview.Invalidate;
  FSrc := '';
  LoadMeter.Progress := 0;
  UpdatePage;
end;

procedure TAceViewerX.LoadReportClick(Sender: TObject);
begin                 
  if OpenFileDialog.Execute then
  begin
    AcePreview.Filer.AceFile := nil;
    AcePreview.AceZoom := az100;
    LoadFile(OpenFileDialog.FileName);
  end;
end;

procedure TAceViewerX.PrintbtnClick(Sender: TObject);
var
  pd: TAcePrintDestination;
  ps: TAcePreviewStatus;
  CopyPS: TAcePrinterSetup;
begin
  CopyPS := TAcePrinterSetup.Create;
  CopyPS.Assign(AcePreview.AcePrinterSetup);

  pd := TAcePrintDestination.Create(Application);
  pd.Viewer := nil;
  pd.Preview := AcePreview;
  pd.AcePrinterSetup := AcePreview.AcePrinterSetup;
  pd.AcePrinterSetup.SetData;

  try
    if (pd.ShowModal = mrOk) then
    begin
      Include(FViewerMode, vmPrinting);
      ToolBar.Enabled := Not (vmPrinting in FViewerMode);
      ps := TAcePreviewStatus.Create(Self);
      try
        ps.Preview := AcePreview;
        ps.Show;
        AcePreview.IgnorePrinterSettings := Not CopyPS.IsEqual(pd.AcePrinterSetup);
        AcePreview.PrintStatus := ps.UpdateStatus;
        AcePreview.SendPagesToPrinter(pd.StartPage, pd.EndPage);
      finally
        ps.free;
      end;
    end;
  finally
    pd.free;
    CopyPS.Free;
    Exclude(FViewerMode, vmPrinting);
    ToolBar.Enabled := Not (vmPrinting in FViewerMode);
  end;
end;

procedure TAceViewerX.PrintSetupClick(Sender: TObject);
begin                 
  AcePreview.AcePrinterSetup.SetData;
  printersetup.execute;
  AcePreview.AcePrinterSetup.GetData;
end;

procedure TAceViewerX.SaveReportClick(Sender: TObject);
begin                                                  
  if AcePreview.Filer.AceFile <> nil then
  begin
    if TAceAceFile(AcePreview.Filer.AceFile).FileName <> '' then
      SaveFileDialog.FileName := TAceAceFile(AcePreview.Filer.AceFile).FileName;
  end;

  if SaveFileDialog.Execute then
  begin
    AcePreview.SaveToFile(SaveFileDialog.FileName);
  end;
end;

procedure TAceViewerX.SBChange(Sender: TObject);
begin                 
  AcePreview.Page := SB.Position;
  UpdatePage;
end;

procedure TAceViewerX.StopClick(Sender: TObject);
begin
  Generating := False;
end;

procedure TAceViewerX.ZoomClick(Sender: TObject);
var entzoom: integer;
begin
  entZoom := AcePreview.Zoom;
  AcePreview.AceZoom := az100;
  AcePreview.Zoom := entZoom+TComponent(Sender).Tag;
  TControl(Sender).Hint :='Zoom to'+IntToStr(AcePreview.Zoom+TComponent(Sender).Tag)+'%'
end;

procedure TAceViewerX.ZoomFitClick(Sender: TObject);
begin
  AcePreview.AceZoom :=TAceZoom(TComponent(Sender).Tag);
  Zoomin.Hint :='Zoom to'+IntToStr(AcePreview.Zoom+Zoomin.Tag)+'%';
end;

initialization
  TActiveFormFactory.Create(
    ComServer,
    TActiveFormControl,
    TAceViewerX,
    Class_AceViewerX,
    1,
    '',
    OLEMISC_SIMPLEFRAME or OLEMISC_ACTSLIKELABEL,
    tmApartment);
end.
