program AcePrint;
{$APPTYPE CONSOLE}
uses
  SysUtils,
  acefile,
  acetypes;

var
  aaf: TAceAceFile;

function IsAceFile(fn: String):Boolean;
var
  Handle: Integer ;
  AceFileHeader: TAceFileHeader;
begin
  Result := False;
  Handle := FileOpen(fn, fmOpenRead);
  if Handle > 0 then
    begin
      FileRead(Handle, AceFileHeader, SizeOf(AceFileHeader));
      if AceFileHeader.Key = 101071 then Result := True;
      FileClose(Handle);
    end
end;

begin
if ParamCount > 0 then
  begin
    if FileExists(ParamStr(1)) then
    begin
      if IsAceFile(ParamStr(1)) then
      begin
        aaf := TAceAceFile.Create;
        aaf.loadfromfile(ParamStr(1));
        with TAcePrinter.Create do
        begin
          loadpages(aaf, 1, aaf.pages.count);
          free;
        end;
        aaf.free;
        WriteLn('File Printed: '+ParamStr(1));
      end else WriteLn(ParamStr(1)+' is not an ACE file');
    end else WriteLn('File ['+ParamStr(1)+'] does not exist.');
  end
else
  begin
    WriteLn('                AcePrint version 2.0');
    WriteLn('      Copyright 2000-2009, SCT Associates, Inc.');
    WriteLn(' ');
    WriteLn('USAGE:  AcePrint Acefilename');
    WriteLn(' ');
    WriteLn('     This program will print the passed ACE file to');
    WriteLn('     the current printer.  To use long filenames that');
    WriteLn('     have embedded spaces, enclose the name in double quotes');
    WriteLn(' ');    
  end;


end.