unit acekey;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,aceview;

type
  TFrmAceKey = class(TForm)
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

type
  TKeyEvent = procedure (Sender: TObject; var Key: Word; Shift: TShiftState) of object;

procedure SetAceKeys(av: TAceViewer);

var
  FrmAceKey: TFrmAceKey;

implementation

{$R *.DFM}

procedure SetAceKeys(av: TAceViewer);
begin
  if not (av = nil) then
  begin
    av.KeyPreview := True;
    av.OnKeyDown := FrmAceKey.FormKeyDown;
  end;
end;

procedure TFrmAceKey.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  WParam  : Integer;
  WParams : array[1..2] of Word absolute WParam;
  av : TAceViewer;
begin
  av := TAceViewer(Sender);
  case Key of
    VK_NEXT : begin
      if ssCtrl in Shift then
        av.CurrentPreview.LastPage
      else if ssShift in Shift then
        av.CurrentPreview.NextPage
      else
        PostMessage(av.CurrentPreview.Handle, WM_VSCROLL, SB_PAGEDOWN, 0);
      av.UpdatePage;
      Key := 0;
    end;
    VK_PRIOR : begin
      if ssCtrl in Shift then
        av.CurrentPreview.FirstPage
      else if ssShift in Shift then
        av.CurrentPreview.PriorPage
      else
        PostMessage(av.CurrentPreview.Handle, WM_VSCROLL, SB_PAGEUP, 0);
      av.UpdatePage;
      Key := 0;
    end;
    VK_DOWN :
      if not (ssCtrl in Shift) then begin
        PostMessage(av.CurrentPreview.Handle, WM_VSCROLL, SB_LINEDOWN, 0);
        Key := 0;
      end;
    VK_UP :
      if not (ssCtrl in Shift) then begin
        PostMessage(av.CurrentPreview.Handle, WM_VSCROLL, SB_LINEUP, 0);
        Key := 0;
      end;
    VK_RIGHT : begin
      if ssCtrl in Shift then
        PostMessage(av.CurrentPreview.Handle, WM_HSCROLL, SB_PAGERIGHT, 0)
      else
        PostMessage(av.CurrentPreview.Handle, WM_HSCROLL, SB_LINERIGHT, 0);
      Key := 0;
    end;
    VK_LEFT : begin
      if ssCtrl in Shift then
        PostMessage(av.CurrentPreview.Handle, WM_HSCROLL, SB_PAGELEFT, 0)
      else
        PostMessage(av.CurrentPreview.Handle, WM_HSCROLL, SB_LINELEFT, 0);
      Key := 0;
    end;
    VK_END :
      {If Ctrl, Alt, Shift, etc. is pressed, don't handle key or change key
       value. Let ancestor handle it.}
      if Shift = [] then begin
        {Set WParam to scroll to far RH side of report. Position 2000 is
sufficient.}
        WParams[1] := SB_THUMBPOSITION;
        WParams[2] := 2000;
        PostMessage(av.CurrentPreview.Handle, WM_HSCROLL, WParam, 0);
        Key := 0;
      end;
    VK_HOME :
      {If Ctrl, Alt, Shift, etc. is pressed, don't handle key or change key
       value. Let ancestor handle it.}
      if Shift = [] then begin
        {Set WParam to scroll to absolute position 0}
        WParams[1] := SB_THUMBPOSITION;
        WParams[2] := 0;
        PostMessage(av.CurrentPreview.Handle, WM_HSCROLL, WParam, 0);
        Key := 0;
      end;
    VK_ESCAPE : Close;
  end;  { case }
end;

end.
