unit AceInfo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SctCtrl, SctVar, ExtCtrls, SctRep, ComCtrls;

type
  TAceInfoFrm = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    btnSave: TButton;
    btnPrint: TButton;
    SaveDialog1: TSaveDialog;
    Memo1: TRichEdit;
    PrintDialog1: TPrintDialog;
    ckPageOneOnly: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    AceFileName: string;
  public
    { Public declarations }
  end;

var
  AceInfoFrm: TAceInfoFrm;

implementation

{$R *.DFM}

uses acefile, acesetup, psetup;

procedure TAceInfoFrm.Button1Click(Sender: TObject);
var
  aaf: TAceAceFile;
  aps: TAcePrinterSetup;
  ps: TSctPageSetup;
  Pages, i: integer;
begin
  if OpenDialog1.Execute then
  begin
    Memo1.Lines.Clear;
    aaf := TAceAceFile.Create;
    ps := TSctPageSetup.Create;
    AceFileName := OpenDialog1.FileName;

    aaf.LoadFromFile(OpenDialog1.FileName); // AAceFileName = path to ace file
    pages := aaf.AceFileInfo.Pages;
    Memo1.Lines.Add('FileName: ['+OpenDialog1.FileName+']');
    Memo1.Lines.Add('---------------AceFileHeader------------------');
    Memo1.Lines.Add('Version : '+FloatToStr(aaf.AceFileHeader.Version));
    Memo1.Lines.Add('HeaderLen : '+IntToStr(aaf.AceFileHeader.HeaderLen));
    Memo1.Lines.Add('Description : '+aaf.AceFileHeader.Description);
    Memo1.Lines.Add('---------------AceFileInfo------------------');
    Memo1.Lines.Add('Pages : '+IntToStr(pages));
    Memo1.Lines.Add('Objects : '+IntToStr(aaf.AceFileInfo.Objects));
    Memo1.Lines.Add('PixelsPerInchX : '+IntToStr(aaf.AceFileInfo.PixelsPerInchX));
    Memo1.Lines.Add('PixelsPerInchY : '+IntToStr(aaf.AceFileInfo.PixelsPerInchY));
    Memo1.Lines.Add('---------------Default PageSetup Info ------');
    aps := TAcePrinterSetup.Create;

    ps.SetSize(TSctPaperSize(aps.PaperSize));
    Memo1.Lines.Add('PageSetup Height:'+ FloatToStr(ps.Height));
    Memo1.Lines.Add('PageSetup Width:'+ FloatToStr(ps.Width));

    i := 1;
    while i <= pages do
    begin
      aaf.GetPagePrinterInfo(aps, i); // pageno = 1
      ps.SetSize(TSctPaperSize(aps.PaperSize));
      Memo1.Lines.Add('---------------AcePrinterSetup Page '+IntToStr(i)+' ------');

      Memo1.Lines.Add('PageSetup Height:'+ FloatToStr(ps.Height));
      Memo1.Lines.Add('PageSetup Width:'+ FloatToStr(ps.Width));

      Memo1.Lines.Add('APS.Width = '+ FloatToStr(aps.width));
      Memo1.Lines.Add('APS.Length = '+FloatToStr(aps.length));
      Memo1.Lines.Add('APS.PaperSize = '+ IntToStr(aps.PaperSize));
      Memo1.Lines.Add('APS.FormNAme = '+ aps.FormName);
      Memo1.Lines.Add('APS.BottomPrintArea = '+FloatToStr(aps.BottomPrintArea));
      Memo1.Lines.Add('APS.TopPrintArea = '+FloatToStr(aps.TopPrintArea));
      Memo1.Lines.Add('APS.YResolution = '+FloatToStr(aps.YResolution));
      Memo1.Lines.Add('APS.PixelsPerInchX = '+FloatToStr(aps.PixelsPerInchX));
      Memo1.Lines.Add('APS.PixelsPerInchY = '+FloatToStr(aps.PixelsPerInchY));
      if ckPageOneOnly.Checked
         then i := pages+1
         else inc(i);
    end;
  end;
  btnSave.Enabled := True;
  btnPrint.Enabled := True;
end;

procedure TAceInfoFrm.btnSaveClick(Sender: TObject);
begin
  SaveDialog1.FileName := ChangeFileExt(AceFileName,'.TXT');
  if SaveDialog1.Execute then
    Memo1.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TAceInfoFrm.btnPrintClick(Sender: TObject);
begin
  if PrintDialog1.Execute then
     Memo1.Print(AceFileName + ' Info');
  //ShowMessage(AceFielName+' Info Printed');
end;

procedure TAceInfoFrm.FormShow(Sender: TObject);
begin
  btnSave.Enabled := False;
  btnPrint.Enabled := False;
end;

end.
