unit aceesc;

interface

{$ifdef WIN32}
  uses windows, sysutils, classes, aceout;
{$else}
  uses wintypes, winprocs, sysutils, classes, aceout;
{$endif}


procedure AceCustomEscapeOut(AceCanvas: TAceCanvas; Text: String);

implementation

uses acefile, aceutil, printers;
type TPrnBuffRec = record
  BuffLength: word;
  Buffer: array[0..255] of char;
end;

const
  Ace_CustomEscapeOut = 12345;


procedure AceCustomEscapeOut(AceCanvas: TAceCanvas; Text: String);
begin
  AceCanvas.AceOutput.AceFile.WriteType(Ace_CustomEscapeOut);
  AceCanvas.AceOutput.AceFile.WriteString(Text);
end;


procedure AcePrintCustomEscapeOut(Handle: THandle; AceFile: TAceAceFile);
var
  Text: String;
  Buff: TPrnBuffRec;
  TestInt: integer;
begin
  AceFile.ReadString(Text);
  TestInt := PASSTHROUGH;
  if Escape(Handle,QUERYESCSUPPORT,sizeof(TestInt),@TestInt,nil) > 0 then
    begin
      StrPCopy(Buff.Buffer,Text);
      Buff.BuffLength := StrLen(Buff.Buffer);
      Escape(Handle,PASSTHROUGH,0,@Buff,nil);
    end;
end;

initialization
  AceAddRecordType(Ace_CustomEscapeOut, AcePrintCustomEscapeOut);

end.
